/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.jte.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jusecase.jte.TemplateException;
import org.jusecase.jte.internal.ClassInfo;

public class ClassFilesCompiler {
    public static void compile(String[] files, List<String> compilePath, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        if (compilePath != null && !compilePath.isEmpty()) {
            String[] args = new String[files.length + 2];
            args[0] = "-classpath";
            args[1] = String.join((CharSequence)File.pathSeparator, compilePath);
            System.arraycopy(files, 0, args, 2, files.length);
            ClassFilesCompiler.runCompiler(args, classDirectory, templateByClassName);
        } else {
            ClassFilesCompiler.runCompiler(files, classDirectory, templateByClassName);
        }
    }

    private static void runCompiler(String[] args, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        ByteArrayOutputStream errorStream;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        int result = compiler.run(null, null, new PrintStream((OutputStream)(errorStream = new ByteArrayOutputStream()), true, StandardCharsets.UTF_8), args);
        if (result != 0) {
            String errors = errorStream.toString(StandardCharsets.UTF_8);
            throw new TemplateException(ClassFilesCompiler.getErrorMessage(errors, classDirectory, templateByClassName));
        }
    }

    private static String getErrorMessage(String errors, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        try {
            String absolutePath = classDirectory.toAbsolutePath().toString();
            int classBeginIndex = errors.indexOf(absolutePath) + absolutePath.length() + 1;
            int classEndIndex = errors.indexOf(".java:");
            String className = errors.substring(classBeginIndex, classEndIndex).replace(File.separatorChar, '.');
            int lineStartIndex = classEndIndex + 6;
            int lineEndIndex = errors.indexOf(58, lineStartIndex);
            int javaLine = Integer.parseInt(errors.substring(lineStartIndex, lineEndIndex));
            ClassInfo templateInfo = templateByClassName.get(className);
            int templateLine = templateInfo.lineInfo[javaLine - 1] + 1;
            return "Failed to compile template, error at " + templateInfo.name + ":" + templateLine + "\n" + errors;
        }
        catch (Exception e) {
            return "Failed to compile template, error at\n" + errors;
        }
    }
}

