/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.executors.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jusecase.UsecaseExecutorException;
import org.jusecase.example.trivial.AppendCharacters;
import org.jusecase.example.trivial.CalculateSum;
import org.jusecase.executors.guice.GuiceUsecaseExecutor;

public class GuiceUsecaseExecutorTest {
    private GuiceUsecaseExecutor executor;
    private UsecaseExecutorException exception;

    @Before
    public void setUp() throws Exception {
        this.executor = new GuiceUsecaseExecutor(Guice.createInjector((Module[])new Module[0]));
    }

    @Test
    public void nullRequest() {
        try {
            this.executor.execute(null);
        }
        catch (UsecaseExecutorException e) {
            this.exception = e;
        }
        this.thenExceptionMessageIs("Request must not be null.");
    }

    @Test
    public void addOneUsecase() {
        this.executor.addUsecase(AppendCharacters.class);
        this.thenAppendCharactersCanBeExecuted();
    }

    @Test
    public void addMultipleUsecases() {
        this.executor.addUsecase(CalculateSum.class);
        this.executor.addUsecase(AppendCharacters.class);
        this.thenAppendCharactersCanBeExecuted();
        this.thenCalculateSumCanBeExecuted();
    }

    @Test
    public void addUsecaseWithAlreadyExistingRequest() {
        this.executor.addUsecase(CalculateSum.class);
        try {
            this.executor.addUsecase(CalculateSum.class);
        }
        catch (UsecaseExecutorException e) {
            this.exception = e;
        }
        this.thenExceptionMessageIs("Request 'org.jusecase.example.trivial.CalculateSum$Request' is already handled by a usecase.");
    }

    @Test
    public void injectorIsExposed() {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        this.executor = new GuiceUsecaseExecutor(injector);
        Assert.assertSame((Object)injector, (Object)this.executor.getInjector());
    }

    private void thenAppendCharactersCanBeExecuted() {
        AppendCharacters.Request request = new AppendCharacters.Request('A', 5);
        Assert.assertEquals((Object)"AAAAA", (Object)this.executor.execute((Object)request));
    }

    private void thenCalculateSumCanBeExecuted() {
        CalculateSum.Request request = new CalculateSum.Request(2, 3);
        Assert.assertEquals((Object)5, (Object)this.executor.execute((Object)request));
    }

    private void thenExceptionMessageIs(String expected) {
        Assert.assertNotNull((String)("Expected exception with message '" + expected + "', but nothing was thrown."), (Object)((Object)this.exception));
        Assert.assertEquals((Object)expected, (Object)this.exception.getMessage());
    }
}

