/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.rules;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jusecase.transaction.TransactionRunner;

public class RunAsTransactionAndRollback
implements TestRule {
    private final TransactionRunner transactionRunner;

    public RunAsTransactionAndRollback(TransactionRunner transactionRunner) {
        this.transactionRunner = transactionRunner;
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){
            private Throwable statementException;

            public void evaluate() throws Throwable {
                try {
                    RunAsTransactionAndRollback.this.transactionRunner.runAsTransaction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                statement.evaluate();
                            }
                            catch (Throwable throwable) {
                                if (throwable instanceof RuntimeException) {
                                    throw (RuntimeException)throwable;
                                }
                                statementException = throwable;
                            }
                            throw new RollbackException();
                        }
                    });
                }
                catch (RollbackException rollbackException) {
                    // empty catch block
                }
                if (this.statementException != null) {
                    throw this.statementException;
                }
            }
        };
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

