/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jusecase.transaction.simple.jdbc.ConnectionProxy;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConnectionProxyTest {
    private ConnectionProxy connectionProxy;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.connectionProxy = new ConnectionProxy(this.connection);
    }

    @Test
    public void getConnection() {
        Assert.assertSame((Object)this.connection, (Object)this.connectionProxy.getConnection());
    }

    @Test
    public void createStatement() throws SQLException {
        this.connectionProxy.createStatement();
        ((Connection)Mockito.verify((Object)this.connection)).createStatement();
        this.connectionProxy.createStatement(1003, 1007);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007);
        this.connectionProxy.createStatement(1003, 1007, 1);
        ((Connection)Mockito.verify((Object)this.connection)).createStatement(1003, 1007, 1);
    }

    @Test
    public void prepareStatement() throws SQLException {
        this.connectionProxy.prepareStatement("statement");
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement");
        this.connectionProxy.prepareStatement("statement", 1);
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement", 1);
        this.connectionProxy.prepareStatement("statement", 1003, 1007);
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement", 1003, 1007);
        this.connectionProxy.prepareStatement("statement", 1003, 1007, 1);
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement", 1003, 1007, 1);
        this.connectionProxy.prepareStatement("statement", new int[]{1, 2});
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement", new int[]{1, 2});
        this.connectionProxy.prepareStatement("statement", new String[]{"a", "b"});
        ((Connection)Mockito.verify((Object)this.connection)).prepareStatement("statement", new String[]{"a", "b"});
    }

    @Test
    public void prepareCall() throws SQLException {
        this.connectionProxy.prepareCall("call");
        ((Connection)Mockito.verify((Object)this.connection)).prepareCall("call");
        this.connectionProxy.prepareCall("call", 1003, 1007);
        ((Connection)Mockito.verify((Object)this.connection)).prepareCall("call", 1003, 1007);
        this.connectionProxy.prepareCall("call", 1003, 1007, 1);
        ((Connection)Mockito.verify((Object)this.connection)).prepareCall("call", 1003, 1007, 1);
    }

    @Test
    public void nativeSQL() throws SQLException {
        this.connectionProxy.nativeSQL("sql");
        ((Connection)Mockito.verify((Object)this.connection)).nativeSQL("sql");
    }

    @Test
    public void setAutoCommit() throws SQLException {
        this.connectionProxy.setAutoCommit(true);
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(true);
    }

    @Test
    public void getAutoCommit() throws SQLException {
        this.connectionProxy.getAutoCommit();
        ((Connection)Mockito.verify((Object)this.connection)).getAutoCommit();
    }

    @Test
    public void commit() throws SQLException {
        this.connectionProxy.commit();
        ((Connection)Mockito.verify((Object)this.connection)).commit();
    }

    @Test
    public void rollback() throws SQLException {
        this.connectionProxy.rollback();
        ((Connection)Mockito.verify((Object)this.connection)).rollback();
        this.connectionProxy.rollback(null);
        ((Connection)Mockito.verify((Object)this.connection)).rollback(null);
    }

    @Test
    public void close() throws SQLException {
        this.connectionProxy.close();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void isClosed() throws SQLException {
        this.connectionProxy.isClosed();
        ((Connection)Mockito.verify((Object)this.connection)).isClosed();
    }

    @Test
    public void getMetaData() throws SQLException {
        this.connectionProxy.getMetaData();
        ((Connection)Mockito.verify((Object)this.connection)).getMetaData();
    }

    @Test
    public void setReadOnly() throws SQLException {
        this.connectionProxy.setReadOnly(true);
        ((Connection)Mockito.verify((Object)this.connection)).setReadOnly(true);
    }

    @Test
    public void isReadOnly() throws SQLException {
        this.connectionProxy.isReadOnly();
        ((Connection)Mockito.verify((Object)this.connection)).isReadOnly();
    }

    @Test
    public void setCatalog() throws SQLException {
        this.connectionProxy.setCatalog("catalog");
        ((Connection)Mockito.verify((Object)this.connection)).setCatalog("catalog");
    }

    @Test
    public void getCatalog() throws SQLException {
        this.connectionProxy.getCatalog();
        ((Connection)Mockito.verify((Object)this.connection)).getCatalog();
    }

    @Test
    public void setTransactionIsolation() throws SQLException {
        this.connectionProxy.setTransactionIsolation(2);
        ((Connection)Mockito.verify((Object)this.connection)).setTransactionIsolation(2);
    }

    @Test
    public void getTransactionIsolation() throws SQLException {
        this.connectionProxy.getTransactionIsolation();
        ((Connection)Mockito.verify((Object)this.connection)).getTransactionIsolation();
    }

    @Test
    public void getWarnings() throws SQLException {
        this.connectionProxy.getWarnings();
        ((Connection)Mockito.verify((Object)this.connection)).getWarnings();
    }

    @Test
    public void clearWarnings() throws SQLException {
        this.connectionProxy.clearWarnings();
        ((Connection)Mockito.verify((Object)this.connection)).clearWarnings();
    }

    @Test
    public void getTypeMap() throws SQLException {
        this.connectionProxy.getTypeMap();
        ((Connection)Mockito.verify((Object)this.connection)).getTypeMap();
    }

    @Test
    public void setTypeMap() throws SQLException {
        this.connectionProxy.setTypeMap(new HashMap());
        ((Connection)Mockito.verify((Object)this.connection)).setTypeMap(new HashMap());
    }

    @Test
    public void setHoldability() throws SQLException {
        this.connectionProxy.setHoldability(2);
        ((Connection)Mockito.verify((Object)this.connection)).setHoldability(2);
    }

    @Test
    public void getHoldability() throws SQLException {
        this.connectionProxy.getHoldability();
        ((Connection)Mockito.verify((Object)this.connection)).getHoldability();
    }

    @Test
    public void setSavepoint() throws SQLException {
        this.connectionProxy.setSavepoint();
        ((Connection)Mockito.verify((Object)this.connection)).setSavepoint();
        this.connectionProxy.setSavepoint("savepoint");
        ((Connection)Mockito.verify((Object)this.connection)).setSavepoint("savepoint");
    }

    @Test
    public void releaseSavepoint() throws SQLException {
        this.connectionProxy.releaseSavepoint(null);
        ((Connection)Mockito.verify((Object)this.connection)).releaseSavepoint(null);
    }

    @Test
    public void createClob() throws SQLException {
        this.connectionProxy.createClob();
        ((Connection)Mockito.verify((Object)this.connection)).createClob();
    }

    @Test
    public void createBlob() throws SQLException {
        this.connectionProxy.createBlob();
        ((Connection)Mockito.verify((Object)this.connection)).createBlob();
    }

    @Test
    public void createNClob() throws SQLException {
        this.connectionProxy.createNClob();
        ((Connection)Mockito.verify((Object)this.connection)).createNClob();
    }

    @Test
    public void createSQLXML() throws SQLException {
        this.connectionProxy.createSQLXML();
        ((Connection)Mockito.verify((Object)this.connection)).createSQLXML();
    }

    @Test
    public void isValid() throws SQLException {
        this.connectionProxy.isValid(100);
        ((Connection)Mockito.verify((Object)this.connection)).isValid(100);
    }

    @Test
    public void setClientInfo() throws SQLException {
        Properties properties = new Properties();
        this.connectionProxy.setClientInfo(properties);
        ((Connection)Mockito.verify((Object)this.connection)).setClientInfo(properties);
        this.connectionProxy.setClientInfo("key", "value");
        ((Connection)Mockito.verify((Object)this.connection)).setClientInfo("key", "value");
    }

    @Test
    public void getClientInfo() throws SQLException {
        this.connectionProxy.getClientInfo();
        ((Connection)Mockito.verify((Object)this.connection)).getClientInfo();
        this.connectionProxy.getClientInfo("value");
        ((Connection)Mockito.verify((Object)this.connection)).getClientInfo("value");
    }

    @Test
    public void createArrayOf() throws SQLException {
        this.connectionProxy.createArrayOf("type", new Object[0]);
        ((Connection)Mockito.verify((Object)this.connection)).createArrayOf("type", new Object[0]);
    }

    @Test
    public void createStruct() throws SQLException {
        this.connectionProxy.createStruct("type", new Object[0]);
        ((Connection)Mockito.verify((Object)this.connection)).createStruct("type", new Object[0]);
    }

    @Test
    public void setSchema() throws SQLException {
        this.connectionProxy.setSchema("1234");
        ((Connection)Mockito.verify((Object)this.connection)).setSchema("1234");
    }

    @Test
    public void getSchema() throws SQLException {
        this.connectionProxy.getSchema();
        ((Connection)Mockito.verify((Object)this.connection)).getSchema();
    }

    @Test
    public void abort() throws SQLException {
        this.connectionProxy.abort(null);
        ((Connection)Mockito.verify((Object)this.connection)).abort(null);
    }

    @Test
    public void setNetworkTimeout() throws SQLException {
        this.connectionProxy.setNetworkTimeout(null, 1000);
        ((Connection)Mockito.verify((Object)this.connection)).setNetworkTimeout(null, 1000);
    }

    @Test
    public void getNetworkTimeout() throws SQLException {
        this.connectionProxy.getNetworkTimeout();
        ((Connection)Mockito.verify((Object)this.connection)).getNetworkTimeout();
    }

    @Test
    public void unwrap() throws SQLException {
        this.connectionProxy.unwrap(String.class);
        ((Connection)Mockito.verify((Object)this.connection)).unwrap(String.class);
    }

    @Test
    public void isWrapperFor() throws SQLException {
        this.connectionProxy.isWrapperFor(String.class);
        ((Connection)Mockito.verify((Object)this.connection)).isWrapperFor(String.class);
    }
}

