/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple.jdbc;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Before;
import org.junit.Test;
import org.jusecase.transaction.simple.TransactionManager;
import org.jusecase.transaction.simple.jdbc.DataSourceProxy;
import org.jusecase.transaction.simple.jdbc.DataSourceTransaction;
import org.mockito.Mockito;

public class DataSourceProxyTest {
    private DataSourceProxy dataSourceProxy;
    private DataSource dataSource;
    private TransactionManager transactionManager;

    @Before
    public void setUp() throws Exception {
        this.dataSource = (DataSource)Mockito.mock(DataSource.class);
        this.transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        this.dataSourceProxy = new DataSourceProxy(this.dataSource, this.transactionManager);
    }

    @Test
    public void getConnection_noTransaction() throws SQLException {
        this.dataSourceProxy.getConnection();
        ((DataSource)Mockito.verify((Object)this.dataSource)).getConnection();
        this.dataSourceProxy.getConnection("user", "password");
        ((DataSource)Mockito.verify((Object)this.dataSource)).getConnection("user", "password");
    }

    @Test
    public void getConnection_transaction() throws SQLException {
        DataSourceTransaction transaction = (DataSourceTransaction)Mockito.mock(DataSourceTransaction.class);
        Mockito.when((Object)this.transactionManager.getCurrent()).thenReturn((Object)transaction);
        this.dataSourceProxy.getConnection();
        ((DataSourceTransaction)Mockito.verify((Object)transaction)).getConnection();
        Mockito.reset((Object[])new DataSourceTransaction[]{transaction});
        this.dataSourceProxy.getConnection("user", "password");
        ((DataSourceTransaction)Mockito.verify((Object)transaction)).getConnection();
    }

    @Test
    public void getLogWriter() throws SQLException {
        this.dataSourceProxy.getLogWriter();
        ((DataSource)Mockito.verify((Object)this.dataSource)).getLogWriter();
    }

    @Test
    public void setLogWriter() throws SQLException {
        this.dataSourceProxy.setLogWriter(null);
        ((DataSource)Mockito.verify((Object)this.dataSource)).setLogWriter(null);
    }

    @Test
    public void setLoginTimeout() throws SQLException {
        this.dataSourceProxy.setLoginTimeout(100);
        ((DataSource)Mockito.verify((Object)this.dataSource)).setLoginTimeout(100);
    }

    @Test
    public void getLoginTimeout() throws SQLException {
        this.dataSourceProxy.getLoginTimeout();
        ((DataSource)Mockito.verify((Object)this.dataSource)).getLoginTimeout();
    }

    @Test
    public void getParentLogger() throws SQLException {
        this.dataSourceProxy.getParentLogger();
        ((DataSource)Mockito.verify((Object)this.dataSource)).getParentLogger();
    }

    @Test
    public void unwrap() throws SQLException {
        this.dataSourceProxy.unwrap(String.class);
        ((DataSource)Mockito.verify((Object)this.dataSource)).unwrap(String.class);
    }

    @Test
    public void isWrapperFor() throws SQLException {
        this.dataSourceProxy.isWrapperFor(String.class);
        ((DataSource)Mockito.verify((Object)this.dataSource)).isWrapperFor(String.class);
    }
}

