/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jusecase.transaction.TransactionError;
import org.jusecase.transaction.simple.SimpleTransactionRunner;
import org.jusecase.transaction.simple.ThreadLocalTransactionManager;
import org.jusecase.transaction.simple.TransactionExecutionError;
import org.jusecase.transaction.simple.TransactionFactory;
import org.jusecase.transaction.simple.TransactionManager;
import org.jusecase.transaction.simple.jdbc.DataSourceTransactionFactory;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SimpleTransactionRunnerTest {
    private SimpleTransactionRunner transactionRunner;
    private DataSource dataSource;
    private Connection connection;
    private Throwable error;

    @Before
    public void setUp() throws Exception {
        this.dataSource = (DataSource)Mockito.mock(DataSource.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        this.transactionRunner = new SimpleTransactionRunner((TransactionManager)new ThreadLocalTransactionManager());
        this.transactionRunner.setTransactionFactory((TransactionFactory)new DataSourceTransactionFactory(this.dataSource, this.transactionRunner.getTransactionManager()));
    }

    @Test
    public void openConnectionError() throws Exception {
        ((DataSource)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.dataSource)).getConnection();
        this.whenTransactionIsExecuted();
        this.thenTransactionInitializationFails();
    }

    @Test
    public void transactionInitializationError() throws Exception {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection)).setAutoCommit(Matchers.anyBoolean());
        this.whenTransactionIsExecuted();
        this.thenTransactionInitializationFails();
        this.thenTransactionIsClosed();
    }

    @Test
    public void commitError() throws Exception {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection)).commit();
        this.whenTransactionIsExecuted();
        this.thenTransactionFailsWithErrorMessage("Failed to commit transaction.");
        this.thenTransactionIsRolledBack();
        this.thenTransactionIsClosed();
    }

    @Test
    public void rollbackError() throws Exception {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection)).rollback();
        this.whenTransactionIsExecuted(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Must rollback!");
            }
        });
        this.thenTransactionFailsWithErrorMessage("Failed to rollback transaction.");
        this.thenTransactionIsClosed();
    }

    @Test
    public void connectionAutoCommitModeIsReset() throws SQLException {
        Mockito.when((Object)this.connection.getAutoCommit()).thenReturn((Object)true);
        this.whenTransactionIsExecuted();
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(false);
        ((Connection)Mockito.verify((Object)this.connection)).setAutoCommit(true);
    }

    @Test
    public void maxTransactionAttempts_initialValue() {
        Assert.assertEquals((long)5L, (long)this.transactionRunner.getMaxTransactionAttempts());
    }

    @Test
    public void maxTransactionAttempts_areConsidered() {
        this.transactionRunner.setMaxTransactionAttempts(3);
        LockedTransaction lockedTransaction = new LockedTransaction();
        this.whenTransactionIsExecuted(lockedTransaction);
        Assert.assertEquals((long)3L, (long)lockedTransaction.getAttempts());
    }

    @Test(expected=TransactionError.class)
    public void nestedTransactionsAreNotSupported() {
        this.transactionRunner.runAsTransaction(new Runnable(){

            @Override
            public void run() {
                SimpleTransactionRunnerTest.this.transactionRunner.runAsTransaction(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        });
    }

    private void whenTransactionIsExecuted() {
        this.whenTransactionIsExecuted(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void whenTransactionIsExecuted(Runnable runnable) {
        try {
            this.transactionRunner.runAsTransaction(runnable);
        }
        catch (Throwable error) {
            this.error = error;
        }
    }

    private void thenTransactionFailsWithErrorMessage(String expected) {
        Assert.assertTrue((boolean)(this.error instanceof TransactionError));
        Assert.assertEquals((Object)expected, (Object)this.error.getMessage());
        Assert.assertNull((Object)this.transactionRunner.getTransactionManager().getCurrent());
    }

    private void thenTransactionInitializationFails() {
        this.thenTransactionFailsWithErrorMessage("Failed to create transaction.");
    }

    private void thenTransactionIsClosed() throws Exception {
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    private void thenTransactionIsRolledBack() throws SQLException {
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)1))).rollback();
    }

    private static class LockedTransactionError
    extends RuntimeException
    implements TransactionExecutionError {
        private LockedTransactionError() {
        }

        public boolean shouldRetryTransaction() {
            return true;
        }
    }

    private static class LockedTransaction
    implements Runnable {
        private int attempts;

        private LockedTransaction() {
        }

        @Override
        public void run() {
            ++this.attempts;
            throw new LockedTransactionError();
        }

        public int getAttempts() {
            return this.attempts;
        }
    }
}

