/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jusecase.transaction.TransactionError;
import org.jusecase.transaction.TransactionRunner;
import org.jusecase.transaction.simple.Transaction;
import org.jusecase.transaction.simple.TransactionExecutionError;
import org.jusecase.transaction.simple.TransactionFactory;
import org.jusecase.transaction.simple.TransactionManager;

@Singleton
public class SimpleTransactionRunner
implements TransactionRunner {
    private TransactionFactory transactionFactory;
    private final TransactionManager transactionManager;
    private int maxTransactionAttempts = 5;

    @Inject
    public SimpleTransactionRunner(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public int getMaxTransactionAttempts() {
        return this.maxTransactionAttempts;
    }

    public void setMaxTransactionAttempts(int maxTransactionAttempts) {
        this.maxTransactionAttempts = maxTransactionAttempts;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public void runAsTransaction(Runnable task) {
        this.runAsTransaction(task, this.maxTransactionAttempts - 1);
    }

    private void runAsTransaction(Runnable task, int attemptsLeft) {
        Transaction transaction = this.startTransaction();
        try {
            task.run();
            transaction.commit();
        }
        catch (RuntimeException error) {
            if (this.shouldRetryTransaction(error) && attemptsLeft > 0) {
                transaction.rollback();
                this.runAsTransaction(task, attemptsLeft - 1);
            }
            transaction.rollback();
            throw error;
        }
    }

    private boolean shouldRetryTransaction(RuntimeException error) {
        return error instanceof TransactionExecutionError && ((TransactionExecutionError)((Object)error)).shouldRetryTransaction();
    }

    private Transaction startTransaction() {
        if (this.transactionManager.getCurrent() != null) {
            throw new TransactionError("Nested transactions are not supported!");
        }
        Transaction transaction = this.transactionFactory.createTransaction();
        this.transactionManager.setCurrent(transaction);
        return transaction;
    }
}

