/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jusecase.transaction.TransactionError;
import org.jusecase.transaction.simple.Transaction;
import org.jusecase.transaction.simple.TransactionManager;
import org.jusecase.transaction.simple.jdbc.ConnectionProxy;

public class DataSourceTransaction
implements Transaction {
    private final TransactionManager transactionManager;
    private final ConnectionProxy connectionProxy;
    private final boolean initialAutoCommitEnabled;

    public DataSourceTransaction(DataSource dataSource, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        try {
            this.connectionProxy = new ConnectionProxy(dataSource.getConnection());
            this.initialAutoCommitEnabled = this.connectionProxy.getAutoCommit();
            this.connectionProxy.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.closeConnectionQuietly();
            throw new TransactionError("Failed to create transaction.", e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.connectionProxy.rollback();
        }
        catch (SQLException e) {
            throw new TransactionError("Failed to rollback transaction.", e);
        }
        finally {
            this.closeTransaction();
        }
    }

    @Override
    public void commit() {
        try {
            this.connectionProxy.commit();
            this.closeTransaction();
        }
        catch (SQLException e) {
            throw new TransactionError("Failed to commit transaction.", e);
        }
    }

    private void closeTransaction() {
        this.transactionManager.setCurrent(null);
        this.closeConnectionQuietly();
    }

    private void closeConnectionQuietly() {
        if (this.connectionProxy != null) {
            try (Connection connection = this.connectionProxy.getConnection();){
                connection.setAutoCommit(this.initialAutoCommitEnabled);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Connection getConnection() {
        return this.connectionProxy;
    }
}

