/*
 * Decompiled with CFR 0.152.
 */
package org.jusecase.transaction.simple.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jusecase.transaction.simple.TransactionManager;
import org.jusecase.transaction.simple.jdbc.DataSourceTransaction;

public class DataSourceProxy
implements DataSource {
    private final DataSource dataSource;
    private final TransactionManager transactionManager;

    public DataSourceProxy(DataSource dataSource, TransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    @Override
    public Connection getConnection() throws SQLException {
        DataSourceTransaction transaction = (DataSourceTransaction)this.transactionManager.getCurrent();
        if (transaction != null) {
            return transaction.getConnection();
        }
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        DataSourceTransaction transaction = (DataSourceTransaction)this.transactionManager.getCurrent();
        if (transaction != null) {
            return transaction.getConnection();
        }
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }
}

