/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.compiler.CompilerConfig;
import juzu.impl.compiler.MessageCode;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.utils.Content;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class CompilationTestCase
extends AbstractTestCase {
    @Test
    public void testErrorCodePattern() {
        this.asserNotMatch("");
        this.asserNotMatch("[]");
        this.asserNotMatch("[a]");
        this.asserNotMatch("[]()");
        this.asserNotMatch("[](a)");
        this.asserMatch("[a]()", "a", "");
        this.asserMatch("[a](b)", "a", "b");
        this.asserMatch("[ERROR_01](5,foobar)", "ERROR_01", "5,foobar");
    }

    private void asserNotMatch(String test) {
        Matcher matcher = Compiler.PATTERN.matcher(test);
        CompilationTestCase.assertFalse((String)("Was not expecting " + Compiler.PATTERN + " to match " + test), (boolean)matcher.matches());
    }

    private void asserMatch(String test, String expectedCode, String expectedArguments) {
        Matcher matcher = Compiler.PATTERN.matcher(test);
        CompilationTestCase.assertTrue((String)("Was expecting " + Compiler.PATTERN + " to match " + test), (boolean)matcher.matches());
        CompilationTestCase.assertEquals((String)expectedCode, (String)matcher.group(1));
        CompilationTestCase.assertEquals((String)expectedArguments, (String)matcher.group(2));
    }

    @Test
    public void testBar() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("compiler", "disk");
        helper.with(null);
        helper.assertCompile();
        CompilationTestCase.assertEquals((int)1, (int)helper.getClassOutput().size(1));
    }

    @Test
    public void testGetResourceFromProcessor() throws Exception {
        DiskFileSystem input = CompilationTestCase.diskFS("compiler", "getresource");
        RAMFileSystem output = new RAMFileSystem();
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)input).output((ReadWriteFileSystem)output).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @SupportedAnnotationTypes(value={"*"})
        @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
        class ProcessorImpl
        extends AbstractProcessor {
            Object result = null;

            ProcessorImpl() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                if (roundEnv.processingOver()) {
                    try {
                        Filer filer = this.processingEnv.getFiler();
                        FileObject o = filer.getResource(StandardLocation.SOURCE_PATH, "compiler.getresource", "A.txt");
                        this.result = o.getCharContent(false);
                    }
                    catch (IOException e) {
                        this.result = e;
                    }
                }
                return false;
            }
        }
        ProcessorImpl processor = new ProcessorImpl();
        compiler.addAnnotationProcessor((Processor)processor);
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile());
        CompilationTestCase.assertEquals((int)1, (int)output.size(1));
        if (processor.result instanceof Exception) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)processor.result);
            throw afe;
        }
        if (processor.result instanceof CharSequence) {
            CompilationTestCase.assertEquals((String)"value", (String)processor.result.toString());
        } else {
            CompilationTestCase.fail((String)("Was not expecting result to be " + processor.result));
        }
    }

    public void _testChange() throws Exception {
        RAMFileSystem ramFS = new RAMFileSystem();
        RAMDir root = ramFS.getRoot();
        RAMDir foo = root.addDir("foo");
        RAMFile a = foo.addFile("A.java").update("package foo; public class A {}");
        RAMFile b = foo.addFile("B.java").update("package foo; public class B {}");
        RAMFileSystem output = new RAMFileSystem();
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)ramFS).output((ReadWriteFileSystem)output).build();
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile());
        CompilationTestCase.assertEquals((int)2, (int)output.size(1));
        Content aClass = output.getContent(new String[]{"foo", "A"});
        CompilationTestCase.assertNotNull((Object)aClass);
        Content bClass = output.getContent(new String[]{"foo", "B"});
        CompilationTestCase.assertNotNull((Object)bClass);
        while (true) {
            b.update("package foo; public class B extends A {}");
            if (bClass.getLastModified() < b.getLastModified()) break;
            Thread.sleep(1L);
        }
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile());
        CompilationTestCase.assertEquals((int)1, (int)output.size(1));
        bClass = output.getContent(new String[]{"foo", "B"});
        CompilationTestCase.assertNotNull((Object)bClass);
    }

    @Test
    public void testProcessor() throws Exception {
        DiskFileSystem ramFS = CompilationTestCase.diskFS("compiler", "processor");
        RAMFileSystem sourceOutput = new RAMFileSystem();
        RAMFileSystem classOutput = new RAMFileSystem();
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)ramFS).sourceOutput((ReadWriteFileSystem)sourceOutput).classOutput((ReadWriteFileSystem)classOutput).build();
        ProcessorImpl processor = new ProcessorImpl();
        compiler.addAnnotationProcessor((Processor)processor);
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile());
        CompilationTestCase.assertEquals((int)2, (int)classOutput.size(1));
        CompilationTestCase.assertEquals(Arrays.asList("compiler.processor.A", "compiler.processor.B"), processor.names);
        CompilationTestCase.assertEquals((int)1, (int)sourceOutput.size(1));
    }

    @Test
    public void testCompilationFailure() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("compiler", "failure");
        CompilationTestCase.assertEquals((int)1, (int)compiler.failCompile().size());
    }

    @Test
    public void testAnnotationException() throws Exception {
        DiskFileSystem fs = CompilationTestCase.diskFS("compiler", "annotationexception");
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
        @SupportedAnnotationTypes(value={"*"})
        class Processor1
        extends AbstractProcessor {
            Processor1() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Deprecated.class);
                if (elements.size() == 1) {
                    Element elt = elements.iterator().next();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "the_message", elt);
                }
                return false;
            }
        }
        compiler.addAnnotationProcessor((Processor)new Processor1());
        List errors = compiler.compile();
        CompilationTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = (CompilationError)errors.get(0);
        CompilationTestCase.assertEquals(null, (Object)error.getCode());
        CompilationTestCase.assertEquals(Collections.emptyList(), error.getArguments());
        CompilationTestCase.assertEquals((String)"/compiler/annotationexception/A.java", (String)error.getSource());
        CompilationTestCase.assertTrue((boolean)error.getMessage().contains("the_message"));
        CompilationTestCase.assertNotNull((Object)error.getSourceFile());
        CompilationTestCase.assertTrue((boolean)error.getSourceFile().getAbsolutePath().endsWith("compiler/annotationexception/A.java"));
        CompilationTestCase.assertNotNull((Object)error.getLocation());
        compiler = Compiler.builder().sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
        @SupportedAnnotationTypes(value={"*"})
        class Processor2
        extends AbstractProcessor {
            boolean failed = false;

            Processor2() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                if (!this.failed) {
                    this.failed = true;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "the_message");
                }
                return false;
            }
        }
        compiler.addAnnotationProcessor((Processor)new Processor2());
        errors = compiler.compile();
        CompilationTestCase.assertEquals((int)1, (int)errors.size());
        error = (CompilationError)errors.get(0);
        CompilationTestCase.assertEquals(null, (Object)error.getCode());
        CompilationTestCase.assertEquals(Collections.emptyList(), error.getArguments());
        CompilationTestCase.assertEquals(null, (String)error.getSource());
        CompilationTestCase.assertTrue((boolean)error.getMessage().contains("the_message"));
        CompilationTestCase.assertNull((Object)error.getSourceFile());
        CompilationTestCase.assertNull((Object)error.getLocation());
    }

    @Test
    public void testErrorCode() throws IOException {
        final MessageCode code = new MessageCode("ERROR_01", "The error");
        DiskFileSystem fs = CompilationTestCase.diskFS("compiler", "errorcode");
        Compiler compiler = Compiler.builder().config(new CompilerConfig().withProcessorOption("juzu.error_reporting", "formal")).sourcePath((ReadFileSystem)fs).output((ReadWriteFileSystem)new RAMFileSystem()).build();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class P
        extends BaseProcessor {
            P() {
            }

            protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws CompilationException {
                if (roundEnv.processingOver()) {
                    throw new CompilationException(code, new Object[]{5, "foobar"});
                }
            }
        }
        P processor = new P();
        compiler.addAnnotationProcessor((Processor)((Object)processor));
        List errors = compiler.compile();
        CompilationTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = (CompilationError)errors.get(0);
        CompilationTestCase.assertEquals((Object)code, (Object)error.getCode());
        CompilationTestCase.assertEquals(Arrays.asList("5", "foobar"), error.getArguments());
    }

    @Test
    public void testIncremental() throws IOException {
        RAMFileSystem sourcePath = new RAMFileSystem();
        RAMFileSystem output = new RAMFileSystem();
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)sourcePath).output((ReadWriteFileSystem)output).build();
        RAMDir incremental = sourcePath.addDir((RAMPath)sourcePath.getRoot(), "compiler").addDir("incremental");
        RAMFile a = incremental.addFile("A.java").update("package compiler.incremental; public class A {}");
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile(new String[]{"compiler/incremental/A.java"}));
        CompilationTestCase.assertEquals((int)1, (int)output.size(1));
        a.del();
        RAMFile b = incremental.addFile("B.java").update("package compiler.incremental; public class B extends A {}");
        compiler = Compiler.builder().sourcePath((ReadFileSystem)sourcePath).addClassPath((SimpleFileSystem)output).output((ReadWriteFileSystem)output).build();
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile(new String[]{"compiler/incremental/B.java"}));
    }

    @Test
    public void testSourceOutputResource() throws IOException {
        this.testResource(StandardLocation.SOURCE_OUTPUT);
    }

    @Test
    public void testClassOutputResource() throws IOException {
        this.testResource(StandardLocation.CLASS_OUTPUT);
    }

    private void testResource(StandardLocation location) throws IOException {
        RAMFileSystem output;
        DiskFileSystem fs = CompilationTestCase.diskFS("compiler", "missingresource");
        RAMFileSystem sourceOutput = new RAMFileSystem();
        RAMFileSystem classOutput = new RAMFileSystem();
        switch (location) {
            case SOURCE_OUTPUT: {
                output = sourceOutput;
                break;
            }
            case CLASS_OUTPUT: {
                output = classOutput;
                break;
            }
            default: {
                throw CompilationTestCase.failure("was not expecting " + location);
            }
        }
        output.addFile((RAMPath)output.getRoot(), "foo.txt").update("foo_value");
        Compiler compiler = Compiler.builder().sourcePath((ReadFileSystem)fs).sourceOutput((ReadWriteFileSystem)sourceOutput).classOutput((ReadWriteFileSystem)classOutput).build();
        compiler.addAnnotationProcessor((Processor)new ReadResource(location));
        CompilationTestCase.assertEquals(Collections.emptyList(), compiler.compile());
        RAMDir root = output.getRoot();
        HashMap<String, RAMFile> children = new HashMap<String, RAMFile>();
        for (RAMPath path : root.getChildren()) {
            if (!(path instanceof RAMFile)) continue;
            children.put(path.getName(), (RAMFile)path);
        }
        CompilationTestCase.assertEquals((int)2, (int)children.size());
        RAMFile foo = (RAMFile)children.get("foo.txt");
        CompilationTestCase.assertEquals((Object)"new_foo_value", (Object)foo.getContent().getCharSequence(Charset.defaultCharset()));
        RAMFile juu = (RAMFile)children.get("juu.txt");
        CompilationTestCase.assertEquals((String)"juu_value", (String)((Object)juu.getContent().getCharSequence(Charset.defaultCharset())).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SupportedAnnotationTypes(value={"*"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
    public static class ReadResource
    extends AbstractProcessor {
        private final StandardLocation location;

        public ReadResource(StandardLocation location) {
            this.location = location;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            try {
                return this._process(annotations, roundEnv);
            }
            catch (IOException e) {
                throw AbstractTestCase.failure(e);
            }
        }

        private boolean _process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
            if (roundEnv.processingOver()) {
                Filer filer = this.processingEnv.getFiler();
                FileObject foo = filer.getResource(this.location, "", "foo.txt");
                Assert.assertNotNull((Object)foo);
                String s = Tools.read((InputStream)foo.openInputStream());
                Assert.assertEquals((String)"foo_value", (String)s);
                foo = filer.createResource(this.location, "", "foo.txt", new Element[0]);
                OutputStream out = foo.openOutputStream();
                out.write("new_foo_value".getBytes());
                out.close();
                FileObject bar = filer.getResource(this.location, "", "bar.txt");
                Assert.assertNotNull((Object)bar);
                try {
                    bar.openInputStream();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                foo = filer.createResource(this.location, "", "juu.txt", new Element[0]);
                out = foo.openOutputStream();
                out.write("juu_value".getBytes());
                out.close();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @SupportedAnnotationTypes(value={"*"})
    @SupportedSourceVersion(value=SourceVersion.RELEASE_6)
    public static class ProcessorImpl
    extends AbstractProcessor {
        final List<String> names = new ArrayList<String>();
        private boolean done;

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            for (Element element : roundEnv.getRootElements()) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElt = (TypeElement)element;
                this.names.add(typeElt.getQualifiedName().toString());
            }
            if (!this.done) {
                try {
                    Filer filer = this.processingEnv.getFiler();
                    JavaFileObject javaFileObject = filer.createSourceFile("compiler.processor.B", new Element[0]);
                    PrintWriter writer = new PrintWriter(javaFileObject.openWriter());
                    writer.println("package compiler.processor; public class B { }");
                    writer.close();
                    this.done = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}

