/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.List;
import juzu.impl.application.metamodel.ApplicationMetaModel;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ApplicationTestCase
extends AbstractTestCase {
    @Test
    public void testAdd() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("model", "meta", "application");
        helper.assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.application.ApplicationApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.application]").list("templates")}));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testUpdate() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "application");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        File pkg = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "application", "package-info.java"});
        FileWriter writer = new FileWriter(pkg, true);
        writer.write(" ");
        writer.close();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)2, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.application.ApplicationApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.application]").list("templates")}));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testRemove() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "application");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        ApplicationTestCase.assertTrue((boolean)((File)helper.getSourcePath().getPath(new String[]{"model", "meta", "application", "package-info.java"})).delete());
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        List events = mm.getQueue().clear();
        ApplicationTestCase.assertEquals((int)1, (int)events.size());
        ApplicationTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ApplicationTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values"));
        ApplicationTestCase.assertEquals(expected, mm.toJSON());
    }
}

