/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import japa.parser.ASTHelper;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.Type;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import juzu.Action;
import juzu.View;
import juzu.impl.application.metamodel.ApplicationMetaModel;
import juzu.impl.application.metamodel.ApplicationsMetaModel;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.controller.metamodel.ControllerMetaModel;
import juzu.impl.controller.metamodel.ControllersMetaModel;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.utils.FQN;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.JavaFile;
import org.junit.Test;

public class ControllerTestCase
extends AbstractTestCase {
    @Test
    public void testBuild() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.controller.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.controller.A,name=index,parameterTypes[]]").set("id", null).set("name", (Object)"index").list("parameters").set("phase", (Object)"RENDER")})}).set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ApplicationMetaModel application = (ApplicationMetaModel)((ApplicationsMetaModel)mm.getChild(ApplicationsMetaModel.KEY)).iterator().next();
        ControllerMetaModel controller = (ControllerMetaModel)((ControllersMetaModel)application.getChild(ControllersMetaModel.KEY)).iterator().next();
        ControllerTestCase.assertEquals(Arrays.asList(MetaModelEvent.createAdded((MetaModelObject)application), MetaModelEvent.createAdded((MetaModelObject)controller), MetaModelEvent.createUpdated((MetaModelObject)controller)), events);
    }

    @Test
    public void testRemoveApplication() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        ControllerTestCase.assertDelete((File)helper.getSourcePath().getPath(new String[]{"model", "meta", "controller", "package-info.java"}));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values"));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)2, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertInstanceOf(ApplicationMetaModel.class, ((MetaModelEvent)events.get(0)).getObject());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(1)).getType());
        ControllerTestCase.assertInstanceOf(ControllerMetaModel.class, ((MetaModelEvent)events.get(1)).getObject());
    }

    @Test
    public void testRemoveController() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        ControllerTestCase.assertDelete((File)helper.getSourcePath().getPath(new String[]{"model", "meta", "controller", "A.java"}));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)1, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertInstanceOf(ControllerMetaModel.class, ((MetaModelEvent)events.get(0)).getObject());
    }

    @Test
    public void testChangeAnnotation() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        MethodDeclaration decl = (MethodDeclaration)a.getMembers().get(0);
        ((AnnotationExpr)decl.getAnnotations().get(0)).setName(ASTHelper.createNameExpr((String)Action.class.getName()));
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.controller.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.controller.A,name=index,parameterTypes[]]").set("id", null).set("name", (Object)"index").list("parameters").set("phase", (Object)"ACTION")})}).set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)3, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ControllerMetaModel));
        ControllerTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(1)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(1)).getObject() instanceof ControllerMetaModel));
        ControllerTestCase.assertEquals((int)2, (int)((MetaModelEvent)events.get(2)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(2)).getObject() instanceof ControllerMetaModel));
    }

    @Test
    public void testRemoveAnnotation() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        MethodDeclaration decl = (MethodDeclaration)a.getMembers().get(0);
        decl.getAnnotations().clear();
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)1, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ControllerMetaModel));
    }

    @Test
    public void testAddMethod() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        MethodDeclaration decl = (MethodDeclaration)a.getMembers().get(0);
        ControllerTestCase.assertTrue((boolean)a.getMembers().remove(decl));
        file.assertSave();
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)1, (int)events.size());
        ControllerTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ApplicationMetaModel));
        Tools.serialize((Serializable)mm, (File)ser);
        a.getMembers().add(decl);
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.controller.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.controller.A,name=index,parameterTypes[]]").set("id", null).set("name", (Object)"index").list("parameters").set("phase", (Object)"RENDER")})}).set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)2, (int)events.size());
        ControllerTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ControllerMetaModel));
        ControllerTestCase.assertEquals((int)2, (int)((MetaModelEvent)events.get(1)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(1)).getObject() instanceof ControllerMetaModel));
    }

    @Test
    public void testRemoveSingleMethod() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        a.getMembers().clear();
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)1, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertTrue((boolean)(((MetaModelEvent)events.get(0)).getObject() instanceof ControllerMetaModel));
    }

    @Test
    public void testRemoveMethod() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        MethodDeclaration show = new MethodDeclaration(1, (Type)ASTHelper.VOID_TYPE, "show");
        show.setAnnotations(Collections.singletonList(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)View.class.getName()), Collections.emptyList())));
        show.setBody(new BlockStmt());
        a.getMembers().add(show);
        file.assertSave();
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        ControllerTestCase.assertTrue((boolean)a.getMembers().remove(show));
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.controller.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.controller.A,name=index,parameterTypes[]]").set("id", null).set("name", (Object)"index").list("parameters").set("phase", (Object)"RENDER")})}).set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)0, (int)events.size());
    }

    @Test
    public void testRemoveOverloadedMethod() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "controller", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        MethodDeclaration index = new MethodDeclaration(1, (Type)ASTHelper.VOID_TYPE, "index");
        ASTHelper.addParameter((MethodDeclaration)index, (Parameter)ASTHelper.createParameter((Type)new ClassOrInterfaceType(String.class.getName()), (String)"s"));
        index.setAnnotations(Collections.singletonList(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)View.class.getName()), Collections.emptyList())));
        index.setBody(new BlockStmt());
        a.getMembers().add(index);
        file.assertSave();
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        ControllerTestCase.assertTrue((boolean)a.getMembers().remove(index));
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.controller.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.controller.A,name=index,parameterTypes[]]").set("id", null).set("name", (Object)"index").list("parameters").set("phase", (Object)"RENDER")})}).set("fqn", (Object)"model.meta.controller.ControllerApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.controller]").list("templates")}));
        ControllerTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)0, (int)events.size());
    }

    @Test
    public void testRefactorPackageName() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "controller");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        File file = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "controller", "A.java"});
        File sub = new File(file.getParentFile(), "sub");
        ControllerTestCase.assertTrue((boolean)sub.mkdir());
        File tmp = new File(sub, file.getName());
        ControllerTestCase.assertTrue((boolean)file.renameTo(tmp));
        JavaFile<File> javaFile = helper.assertJavaFile("model", "meta", "controller", "sub", "A.java");
        javaFile.assertCompilationUnit().getPackage().setName(ASTHelper.createNameExpr((String)"model.meta.controller.sub"));
        javaFile.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        List events = mm.getQueue().clear();
        ControllerTestCase.assertEquals((int)3, (int)events.size());
        ControllerTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        ControllerTestCase.assertEquals((Object)ElementHandle.Class.create((FQN)new FQN("model.meta.controller.A")), (Object)((ControllerMetaModel)((MetaModelEvent)events.get(0)).getObject()).getHandle());
        ControllerTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(1)).getType());
        ControllerTestCase.assertEquals((Object)ElementHandle.Class.create((FQN)new FQN("model.meta.controller.sub.A")), (Object)((ControllerMetaModel)((MetaModelEvent)events.get(1)).getObject()).getHandle());
        ControllerTestCase.assertEquals((int)2, (int)((MetaModelEvent)events.get(2)).getType());
        ControllerTestCase.assertEquals((Object)ElementHandle.Class.create((FQN)new FQN("model.meta.controller.sub.A")), (Object)((ControllerMetaModel)((MetaModelEvent)events.get(2)).getObject()).getHandle());
    }
}

