/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.util.Arrays;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class MethodParametersTestCase
extends AbstractInjectTestCase {
    public MethodParametersTestCase(InjectImplementation di) {
        super(di);
    }

    @Test
    public void testStringArray() throws Exception {
        MockApplication<?> app = this.application("request", "method", "parameters", "string", "array").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render("none");
        MockRenderBridge mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("0");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("1");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar").toString(), (String)mv.assertStringResult());
        render = client.render("2");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar_1", "bar_2").toString(), (String)mv.assertStringResult());
    }

    @Test
    public void testStringList() throws Exception {
        MockApplication<?> app = this.application("request", "method", "parameters", "string", "list").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render("none");
        MockRenderBridge mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("0");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("1");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar").toString(), (String)mv.assertStringResult());
        render = client.render("2");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar_1", "bar_2").toString(), (String)mv.assertStringResult());
    }

    @Test
    public void testBean() throws Exception {
        MockApplication<?> app = this.application("request", "method", "parameters", "bean").init();
        MockClient client = app.client();
        this.assertBean(client, "a", "v");
        this.assertBean(client, "b", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "c", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "d", "v");
        this.assertBean(client, "e", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "f", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "g", "s_valuev");
        this.assertBean(client, "g", "s_valuev");
        this.assertBean(client, "h", "s_valuev");
    }

    private void assertBean(MockClient client, String name, Object expected) throws Exception {
        MockRenderBridge render = client.render(name);
        String url = render.assertStringResult();
        MockRenderBridge m = (MockRenderBridge)client.invoke(url);
        MethodParametersTestCase.assertEquals((Object)expected, (Object)m.assertStringResult());
        render = client.render(name + "Action");
        url = render.assertStringResult();
        MockActionBridge action = (MockActionBridge)client.invoke(url);
        MockRenderBridge m2 = (MockRenderBridge)client.invoke(action.assertUpdate());
        MethodParametersTestCase.assertEquals((Object)expected, (Object)m2.assertStringResult());
    }
}

