/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import juzu.URLBuilder;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.utils.JSON;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class URLTestCase
extends AbstractInjectTestCase {
    public URLTestCase(InjectImplementation di) {
        super(di);
    }

    @Test
    public void testSimple() throws Exception {
        MockApplication<?> app = this.application("request", "url", "simple");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        JSON url = (JSON)JSON.parse((String)render.assertStringResult());
        URLTestCase.assertFalse((boolean)url.getJSON("properties").contains(URLBuilder.ESCAPE_XML.class.getName()));
    }

    @Test
    public void testEscapeXML() throws Exception {
        MockApplication<?> app = this.application("request", "url", "escapexml");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        JSON url = (JSON)JSON.parse((String)render.assertStringResult());
        URLTestCase.assertEquals((Object)Boolean.TRUE, (Object)url.getJSON("properties").get(URLBuilder.ESCAPE_XML.class.getName()));
    }

    @Test
    public void testInvalidProperty() throws Exception {
        MockApplication<?> app = this.application("request", "url", "invalidproperty");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        URLTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }
}

