/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.ast;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import juzu.impl.compiler.CompilationException;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.ast.ParseException;
import juzu.impl.template.spi.juzu.compiler.EmitPhase;
import juzu.impl.template.spi.juzu.compiler.ProcessPhase;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateEmitter;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateStub;
import juzu.impl.utils.MethodInvocation;
import juzu.impl.utils.Path;
import juzu.io.AppendableStream;
import juzu.io.Stream;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;
import juzu.test.AbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateTestCase
extends AbstractTestCase {
    public GroovyTemplateStub template(String text) throws IOException {
        GroovyTemplateEmitter generator = new GroovyTemplateEmitter();
        try {
            ProcessPhase processPhase = new ProcessPhase(new ProcessContext(Collections.emptyMap()){

                public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws CompilationException {
                    if (parameterMap.size() > 0) {
                        throw AbstractTestCase.failure("Unexpected non empty parameter map");
                    }
                    Class<?> clazz = ((Object)((Object)AbstractTemplateTestCase.this)).getClass();
                    try {
                        Method m = clazz.getMethod(methodName, new Class[0]);
                        return new MethodInvocation(clazz.getName(), m.getName(), Collections.emptyList());
                    }
                    catch (NoSuchMethodException e) {
                        throw AbstractTestCase.failure(e);
                    }
                }
            });
            Template template = new Template(Path.parse((String)"index.gtmpl"), (Serializable)ASTNode.Template.parse((CharSequence)text), Path.parse((String)"index.gtmpl"), 0L);
            processPhase.process(template);
            EmitPhase emitPhase = new EmitPhase(new EmitContext());
            emitPhase.emit((DialectTemplateEmitter)generator, (ASTNode)template.getModel());
        }
        catch (ParseException e) {
            throw AbstractTemplateTestCase.failure(e);
        }
        GroovyTemplateStub stub = generator.build("template_" + Math.abs(new Random().nextLong()));
        stub.init(Thread.currentThread().getContextClassLoader());
        return stub;
    }

    public String render(String template) throws IOException, TemplateExecutionException {
        return this.render(template, null, null);
    }

    public String render(String template, Locale locale) throws IOException, TemplateExecutionException {
        return this.render(template, null, locale);
    }

    public String render(String template, Map<String, ?> attributes) throws IOException, TemplateExecutionException {
        return this.render(template, attributes, null);
    }

    public String render(String text, Map<String, ?> attributes, Locale locale) throws IOException, TemplateExecutionException {
        StringWriter out = new StringWriter();
        this.render(text, attributes, locale, out);
        return out.toString();
    }

    public void render(String text, Map<String, ?> attributes, Locale locale, Appendable appendable) throws IOException, TemplateExecutionException {
        GroovyTemplateStub template = this.template(text);
        TemplateRenderContext renderContext = new TemplateRenderContext((TemplateStub)template, null, attributes, locale);
        renderContext.render((Stream.Char)new AppendableStream(appendable));
    }
}

