/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.ast;

import java.awt.AWTError;
import java.awt.AWTException;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Locale;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.ast.AbstractTemplateTestCase;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateStub;
import juzu.io.AppendableStream;
import juzu.io.Stream;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;
import juzu.test.protocol.mock.MockPrinter;
import org.junit.Test;

public class TemplateRenderingTestCase
extends AbstractTemplateTestCase {
    private DateFormat dateFormatFR;
    private DateFormat dateFormatEN;
    public static Object out;

    public void setUp() throws Exception {
        super.setUp();
        this.dateFormatFR = DateFormat.getDateInstance(2, Locale.FRANCE);
        this.dateFormatEN = DateFormat.getDateInstance(2, Locale.ENGLISH);
    }

    @Test
    public void testDate1() throws Exception {
        Date dateToTest = new Date(0L);
        String template = "<% print(new Date(0)); %>";
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)this.render(template, Locale.FRENCH));
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)this.render(template, Locale.ENGLISH));
        TemplateRenderingTestCase.assertEquals((String)dateToTest.toString(), (String)this.render(template));
    }

    @Test
    public void testDate2() throws Exception {
        Date dateToTest = new Date(0L);
        String template = "<% def date = new Date(0) %>${date}";
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)this.render(template, Locale.FRENCH));
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)this.render(template, Locale.ENGLISH));
        TemplateRenderingTestCase.assertEquals((String)dateToTest.toString(), (String)this.render(template));
    }

    @Test
    public void testDate3() throws Exception {
        Date dateToTest = new Date(0L);
        String template = "<%= new Date(0) %>";
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)this.render(template, Locale.FRENCH));
        TemplateRenderingTestCase.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)this.render(template, Locale.ENGLISH));
        TemplateRenderingTestCase.assertEquals((String)dateToTest.toString(), (String)this.render(template));
    }

    @Test
    public void testFoo() throws Exception {
        String template = "a";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a", (String)render);
    }

    @Test
    public void testBar() throws Exception {
        String template = "<%='a'%>";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a", (String)render);
    }

    @Test
    public void testFooBar() throws Exception {
        String template = "a<%='b'%>c";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"abc", (String)render);
    }

    @Test
    public void testJuu() throws Exception {
        String template = "<% out.print(\"a\"); %>";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a", (String)render);
    }

    @Test
    public void testLineBreak() throws Exception {
        String template = "\n";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"\n", (String)render);
    }

    @Test
    public void testMultiLine() throws Exception {
        String template = "a\nb\n<%= 'c' %>\nd";
        String render = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a\nb\nc\nd", (String)render);
    }

    @Test
    public void testIf() throws Exception {
        String template = "a\n<% if (true) {\n %>b\n<% } %>";
        String s = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a\nb\n", (String)s);
    }

    @Test
    public void testLineComment() throws Exception {
        String template = "<% // foo %>a\nb";
        String s = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"a\nb", (String)s);
    }

    @Test
    public void testContextResolution() throws Exception {
        String template = "<%= foo %>";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"bar", (String)s);
    }

    @Test
    public void testDollarInExpression() throws Exception {
        String template = "<%= \"$foo\" %>";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"bar", (String)s);
    }

    @Test
    public void testEscapeDollarInExpression() throws Exception {
        String template = "<%= \"\\$foo\" %>";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"$foo", (String)s);
    }

    @Test
    public void testEscapeDollarInText() throws Exception {
        String template = "\\$foo";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"$foo", (String)s);
    }

    @Test
    public void testDollarInScriplet() throws Exception {
        String template = "<% out.print(\"$foo\") %>";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"bar", (String)s);
    }

    @Test
    public void testEscapeDollarInScriplet() throws Exception {
        String template = "<% out.print(\"\\$foo\") %>";
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = this.render(template, context);
        TemplateRenderingTestCase.assertEquals((String)"$foo", (String)s);
    }

    @Test
    public void testQuote() throws Exception {
        String template = "\"";
        String s = this.render(template);
        TemplateRenderingTestCase.assertEquals((String)"\"", (String)s);
    }

    @Test
    public void testNoArgURL() throws Exception {
        String s = this.render("@{foo()}");
        TemplateRenderingTestCase.assertEquals((String)"foo_value", (String)s);
    }

    public static String foo() {
        return "foo_value";
    }

    public static String echo(String s) {
        return s;
    }

    @Test
    public void testException() throws Exception {
        String template = "<% throw new java.awt.AWTException(); %>";
        try {
            this.render(template);
            TemplateRenderingTestCase.fail();
        }
        catch (TemplateExecutionException e) {
            TemplateRenderingTestCase.assertTrue((boolean)(e.getCause() instanceof AWTException));
        }
    }

    @Test
    public void testRuntimeException() throws Exception {
        String template = "<% throw new java.util.EmptyStackException(); %>";
        try {
            this.render(template);
            TemplateRenderingTestCase.fail();
        }
        catch (TemplateExecutionException e) {
            TemplateRenderingTestCase.assertTrue((boolean)(e.getCause() instanceof EmptyStackException));
        }
    }

    @Test
    public void testSiblingClosures() throws IOException {
        GroovyTemplateStub template = this.template("#{title value=a/}#{title value=b/}");
        template.getClassName();
    }

    @Test
    public void testIOException() throws Exception {
        String template = "<% throw new java.io.IOException(); %>";
        try {
            this.render(template);
            TemplateRenderingTestCase.fail();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.render("foobar", null, null, new Appendable(){

                public Appendable append(CharSequence csq) throws IOException {
                    throw new IOException();
                }

                public Appendable append(CharSequence csq, int start, int end) throws IOException {
                    throw new IOException();
                }

                public Appendable append(char c) throws IOException {
                    throw new IOException();
                }
            });
            TemplateRenderingTestCase.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testError() throws Exception {
        String template = "<% throw new java.awt.AWTError(); %>";
        try {
            this.render(template);
            TemplateRenderingTestCase.fail();
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
    }

    @Test
    public void testThrowable() throws Exception {
        String template = "<% throw new Throwable(); %>";
        try {
            this.render(template);
            TemplateRenderingTestCase.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testScriptLineNumber() throws Exception {
        this.testLineNumber("<%");
        this.assertLineNumber(2, "throw new Exception('e')", "<%\nthrow new Exception('e')%>");
    }

    @Test
    public void testExpressionLineNumber() throws Exception {
        this.testLineNumber("<%=");
    }

    private void testLineNumber(String prolog) throws Exception {
        this.assertLineNumber(1, "throw new Exception('a')", prolog + "throw new Exception('a')%>");
        this.assertLineNumber(1, "throw new Exception('b')", "foo" + prolog + "throw new Exception('b')%>");
        this.assertLineNumber(2, "throw new Exception('c')", "foo\n" + prolog + "throw new Exception('c')%>");
        this.assertLineNumber(1, "throw new Exception('d')", "<%;%>foo" + prolog + "throw new Exception('d')%>");
    }

    @Test
    public void testWriterAccess() throws Exception {
        out = null;
        StringWriter writer = new StringWriter();
        GroovyTemplateStub template = this.template("<% " + TemplateRenderingTestCase.class.getName() + ".out = out; %>");
        new TemplateRenderContext((TemplateStub)template).render((Stream.Char)new AppendableStream((Appendable)writer));
        TemplateRenderingTestCase.assertNotNull((Object)out);
    }

    private void assertLineNumber(int expectedLineNumber, String expectedText, String script) throws IOException {
        GroovyTemplateStub template = this.template(script);
        try {
            new TemplateRenderContext((TemplateStub)template).render((Stream.Char)new MockPrinter());
            TemplateRenderingTestCase.fail();
        }
        catch (TemplateExecutionException t) {
            TemplateRenderingTestCase.assertEquals((String)expectedText, (String)t.getText());
            TemplateRenderingTestCase.assertEquals((Object)expectedLineNumber, (Object)t.getLineNumber());
            StackTraceElement scriptElt = null;
            for (StackTraceElement elt : t.getCause().getStackTrace()) {
                if (!elt.getClassName().equals(template.getClassName())) continue;
                scriptElt = elt;
                break;
            }
            TemplateRenderingTestCase.assertEquals((int)expectedLineNumber, (int)scriptElt.getLineNumber());
        }
    }
}

