/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.test.AbstractTestCase;
import juzu.test.UserAgent;
import juzu.test.protocol.http.InvocationServlet;
import juzu.test.protocol.mock.MockApplication;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public abstract class AbstractHttpTestCase
extends AbstractTestCase {
    private static AbstractHttpTestCase currentTest;
    private MockApplication<?> application;
    @ArquillianResource
    protected URL deploymentURL;

    public static MockApplication<?> getApplication() throws IllegalStateException {
        if (currentTest == null) {
            throw new IllegalStateException("No deployed test");
        }
        return AbstractHttpTestCase.currentTest.application;
    }

    @Override
    public void setUp() {
        currentTest = this;
    }

    @Override
    public void tearDown() {
        this.application = null;
        currentTest = null;
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        URL descriptor = InvocationServlet.class.getResource("web.xml");
        URL jquery = InvocationServlet.class.getResource("jquery-1.7.1.js");
        URL stylesheet = InvocationServlet.class.getResource("main.css");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"juzu.war")).addAsWebResource(jquery, "jquery.js")).addAsWebResource(stylesheet, "main.css")).setWebXML(descriptor);
    }

    public MockApplication<?> assertDeploy(String ... packageName) {
        try {
            this.application = this.application(InjectImplementation.CDI_WELD, packageName);
            return this.application;
        }
        catch (Exception e) {
            throw AbstractHttpTestCase.failure("Could not deploy application " + Arrays.asList(packageName), e);
        }
    }

    public void assertInternalError() {
        WebClient client = new WebClient();
        try {
            Page page = client.getPage(this.deploymentURL + "/juzu");
            throw AbstractHttpTestCase.failure("Was expecting an internal error instead of page " + page.toString());
        }
        catch (FailingHttpStatusCodeException e) {
            AbstractHttpTestCase.assertEquals((int)500, (int)e.getStatusCode());
        }
        catch (IOException e) {
            throw AbstractHttpTestCase.failure("Was not expecting io exception", e);
        }
    }

    public UserAgent assertInitialPage() {
        return new UserAgent(this.deploymentURL);
    }
}

