/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.util.HashMap;
import java.util.Map;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry {
    private static final Map<Object, Object> state = new HashMap<Object, Object>();

    public static <T> T get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object t = state.get(key);
        return (T)t;
    }

    public static <T> T compareAndSet(Object key, T expectedValue, T value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object previous = state.get(key);
        if (Tools.safeEquals((Object)previous, expectedValue)) {
            state.put(key, value);
        }
        return (T)previous;
    }

    public static <T> void set(Object key, T value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            state.put(key, value);
        } else {
            state.remove(key);
        }
    }

    public static <T> T unset(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return (T)state.remove(key);
    }

    public static void clear() {
        state.clear();
    }
}

