/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import juzu.test.AbstractTestCase;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgent {
    private WebClient client;
    private final URL homeURL;
    private Page currentPage;
    private IdentityHashMap<Page, List<String>> alerts;

    public UserAgent(URL homeURL) {
        WebClient client = new WebClient(BrowserVersion.FIREFOX_3_6);
        client.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String message) {
                ArrayList<String> l = (ArrayList<String>)UserAgent.this.alerts.get(page);
                if (l == null) {
                    l = new ArrayList<String>();
                    UserAgent.this.alerts.put(page, l);
                }
                l.add(message);
            }
        });
        this.alerts = new IdentityHashMap();
        this.client = client;
        this.homeURL = homeURL;
    }

    public HtmlPage getPage(URL url) {
        return this.getPage(HtmlPage.class, url);
    }

    public HtmlPage getPage(String path) {
        return this.getPage(HtmlPage.class, path);
    }

    public <P extends Page> P getPage(Class<P> pageType, URL url) {
        Page page;
        try {
            page = this.client.getPage(url);
        }
        catch (FailingHttpStatusCodeException e) {
            throw AbstractTestCase.failure("Cannot get initial page", e);
        }
        catch (IOException e) {
            throw AbstractTestCase.failure("Cannot get initial page", e);
        }
        if (pageType.isInstance(page)) {
            this.currentPage = page;
            return (P)((Page)pageType.cast(page));
        }
        throw AbstractTestCase.failure("Was expecting an HTML page instead of " + page + " for URL " + page.getUrl());
    }

    public <P extends Page> P getPage(Class<P> pageType, String path) {
        URL url;
        try {
            url = this.homeURL.toURI().resolve(path).toURL();
        }
        catch (Exception e) {
            throw AbstractTestCase.failure("Cannot build page URL " + path);
        }
        return this.getPage(pageType, url);
    }

    public HtmlPage getHomePage() {
        return this.getPage(this.homeURL);
    }

    public void assertRedirect(String expectedLocation, String url) {
        boolean redirectEnabled = this.client.isRedirectEnabled();
        boolean throwExceptionOnFailingStatusCode = this.client.isThrowExceptionOnFailingStatusCode();
        try {
            this.client.setRedirectEnabled(false);
            this.client.setThrowExceptionOnFailingStatusCode(false);
            Page redirect = this.client.getPage(url);
            WebResponse resp = redirect.getWebResponse();
            Assert.assertEquals((long)302L, (long)resp.getStatusCode());
            Assert.assertEquals((Object)expectedLocation, (Object)resp.getResponseHeaderValue("Location"));
        }
        catch (IOException e) {
            throw AbstractTestCase.failure("Cannot get load " + url, e);
        }
        finally {
            this.client.setRedirectEnabled(redirectEnabled);
            this.client.setThrowExceptionOnFailingStatusCode(throwExceptionOnFailingStatusCode);
        }
    }

    public List<String> getAlerts(Page page) {
        return this.alerts.get(page);
    }
}

