/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import juzu.impl.application.ApplicationException;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockRenderBridge;
import juzu.test.protocol.mock.MockRequestBridge;
import juzu.test.protocol.mock.MockResourceBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClient {
    final MockApplication<?> application;
    private ScopedContext session;
    private ScopedContext flash;
    private final LinkedList<List<Scoped>> flashHistory;

    private MockRequestBridge create(String url) {
        MockRequestBridge request;
        try {
            JSON json = (JSON)JSON.parse((String)url);
            JSON jsonParams = json.getJSON("parameters");
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            for (String name : jsonParams.names()) {
                List value = jsonParams.getList(name, String.class);
                parameters.put(name, value.toArray(new String[value.size()]));
            }
            String methodId = json.getJSON("properties").getString(RequestContext.METHOD_ID.class.getName());
            Phase phase = Phase.valueOf((String)json.getString("phase"));
            switch (phase) {
                case ACTION: {
                    request = new MockActionBridge(this, methodId, parameters);
                    break;
                }
                case RENDER: {
                    request = new MockRenderBridge(this, methodId, parameters);
                    break;
                }
                case RESOURCE: {
                    request = new MockResourceBridge(this, methodId, parameters);
                    break;
                }
                default: {
                    throw AbstractTestCase.failure("Not yet supported " + phase);
                }
            }
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
        return request;
    }

    public MockClient(MockApplication<?> application) {
        this.application = application;
        this.session = new ScopedContext();
        this.flash = null;
        this.flashHistory = new LinkedList();
    }

    public MockRenderBridge render(String methodId) throws ApplicationException {
        MockRenderBridge render = new MockRenderBridge(this, methodId, new HashMap<String, String[]>());
        this.invoke(render);
        return render;
    }

    public MockRenderBridge render() throws ApplicationException {
        return this.render(null);
    }

    public MockRequestBridge invoke(String url) throws ApplicationException {
        MockRequestBridge request = this.create(url);
        this.invoke(request);
        return request;
    }

    public Scoped getFlashValue(Object key) {
        return this.flash != null ? this.flash.get(key) : null;
    }

    public void setFlashValue(Object key, Scoped value) {
        if (this.flash == null) {
            this.flash = new ScopedContext();
        }
        this.flash.set(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(MockRequestBridge request) throws ApplicationException {
        try {
            this.application.invoke(request);
        }
        finally {
            request.close();
            if (request instanceof MockRenderBridge) {
                if (this.flash != null) {
                    this.flashHistory.addFirst(Tools.list((Iterable)this.flash));
                    this.flash.close();
                    this.flash = null;
                } else {
                    this.flashHistory.addFirst(Collections.emptyList());
                }
            }
        }
    }

    public List<Scoped> getFlashHistory(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Wrong index " + index);
        }
        if (index == 0) {
            return Tools.list((Iterable)this.flash);
        }
        return this.flashHistory.get(index - 1);
    }

    public ScopedContext getSession() {
        return this.session;
    }

    public void invalidate() {
        this.session.close();
        this.session = new ScopedContext();
    }
}

