/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import juzu.Action;
import juzu.Resource;
import juzu.Scope;
import juzu.View;
import juzu.impl.application.ApplicationContext;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.application.ApplicationException;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.inject.BeanFilter;
import juzu.impl.inject.Export;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectBuilder;
import juzu.impl.inject.spi.InjectManager;
import juzu.impl.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationBootstrap {
    public final InjectBuilder bootstrap;
    public final ApplicationDescriptor descriptor;
    private BeanLifeCycle<ApplicationContext> contextLifeCycle;

    public ApplicationBootstrap(InjectBuilder bootstrap, ApplicationDescriptor descriptor) {
        this.bootstrap = bootstrap;
        this.descriptor = descriptor;
    }

    public void start() throws ApplicationException {
        this._start();
    }

    private <B, I> void _start() throws ApplicationException {
        InjectManager manager;
        this.bootstrap.bindBean(ApplicationDescriptor.class, null, this.descriptor);
        this.bootstrap.declareBean(ApplicationContext.class, null, null, null);
        this.bootstrap.setFilter(new BeanFilter(){

            @Override
            public <T> boolean acceptBean(Class<T> beanType) {
                if (beanType.getName().startsWith("juzu.") || beanType.getAnnotation(Export.class) != null) {
                    return false;
                }
                for (Method method : beanType.getMethods()) {
                    if (method.getAnnotation(View.class) == null && method.getAnnotation(Action.class) == null && method.getAnnotation(Resource.class) == null) continue;
                    return false;
                }
                return true;
            }
        });
        for (Scope scope : Scope.values()) {
            this.bootstrap.addScope(scope);
        }
        for (Plugin plugin : this.descriptor.getFoo().values()) {
            Class<?> aClass = plugin.getClass();
            Plugin o = plugin;
            this.bootstrap.bindBean(aClass, null, o);
        }
        for (BeanDescriptor bean : this.descriptor.getBeans()) {
            bean.install(this.bootstrap);
        }
        try {
            manager = this.bootstrap.create();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        BeanLifeCycle<ApplicationContext> contextLifeCycle = manager.get(ApplicationContext.class);
        try {
            contextLifeCycle.get();
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        this.contextLifeCycle = contextLifeCycle;
    }

    public ApplicationContext getContext() {
        return this.contextLifeCycle.peek();
    }

    public void stop() {
        this.contextLifeCycle.release();
    }
}

