/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.application.ApplicationRuntime;
import juzu.impl.utils.NameLiteral;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetServer {
    public static final Named PLUGIN = new NameLiteral("plugin");
    public static final Named APPLICATION = new NameLiteral("application");
    HashSet<ApplicationRuntime<?, ?, ?>> runtimes = new HashSet();

    public void register(ApplicationRuntime<?, ?, ?> assetManager) {
        this.runtimes.add(assetManager);
    }

    public void unregister(ApplicationRuntime<?, ?, ?> assetManager) {
        this.runtimes.remove(assetManager);
    }

    void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path != null && path.length() > 0) {
            for (ApplicationRuntime<?, ?, ?> runtime : this.runtimes) {
                InputStream in;
                String contentType;
                if (runtime.getScriptManager().isClassPath(path)) {
                    contentType = "text/javascript";
                    in = runtime.getContext().getClassLoader().getResourceAsStream(path.substring(1));
                } else if (runtime.getStylesheetManager().isClassPath(path)) {
                    contentType = "text/css";
                    in = runtime.getContext().getClassLoader().getResourceAsStream(path.substring(1));
                } else {
                    contentType = null;
                    in = null;
                }
                if (in == null) continue;
                resp.setContentType(contentType);
                Tools.copy(in, (OutputStream)resp.getOutputStream());
            }
        }
    }
}

