/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import juzu.impl.compiler.CompilationException;

public class MessageCode {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final ConcurrentHashMap<String, MessageCode> codes = new ConcurrentHashMap();
    private final String key;
    private final String message;

    public static MessageCode decode(String key) {
        return codes.get(key);
    }

    public MessageCode(String key, String message) {
        codes.put(key, this);
        this.key = key;
        this.message = message;
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "MessageCode[key=" + this.key + ",message=" + this.message + "]";
    }

    public CompilationException failure(Object ... args) {
        return new CompilationException(this, args);
    }

    public CompilationException failure(Element element) {
        return new CompilationException(element, this, EMPTY_OBJECT_ARRAY);
    }

    public CompilationException failure(Element element, Object ... args) {
        return new CompilationException(element, this, args);
    }

    public CompilationException failure(Element element, AnnotationMirror annotation, Object ... args) {
        return new CompilationException(element, annotation, this, args);
    }
}

