/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.fs.spi.ram.RAMURLConnection;
import juzu.impl.utils.Content;
import juzu.impl.utils.Spliterator;

public class RAMURLStreamHandler
extends URLStreamHandler {
    private RAMFileSystem fs;

    public RAMURLStreamHandler(RAMFileSystem fs) {
        this.fs = fs;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        Content content;
        Iterable<String> names = Spliterator.split(u.getPath().substring(1), '/');
        RAMPath path = (RAMPath)this.fs.getPath(names);
        if (path instanceof RAMFile && (content = ((RAMFile)path).getContent()) != null) {
            return new RAMURLConnection(u, content);
        }
        throw new IOException("Could not connect to non existing content " + names);
    }
}

