/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.portlet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import juzu.PropertyType;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.request.Request;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.request.spi.portlet.PortletBridgeContext;
import juzu.impl.request.spi.portlet.PortletHttpContext;
import juzu.impl.request.spi.portlet.PortletSecurityContext;
import juzu.impl.request.spi.portlet.PortletWindowContext;
import juzu.portlet.JuzuPortlet;
import juzu.request.HttpContext;
import juzu.request.RequestContext;
import juzu.request.SecurityContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletRequestBridge<Rq extends PortletRequest, Rs extends PortletResponse>
implements RequestBridge {
    protected final PortletBridgeContext context;
    protected final Rq req;
    protected final Rs resp;
    protected final String methodId;
    protected final Map<String, String[]> parameters;
    protected final PortletHttpContext httpContext;
    protected final PortletSecurityContext securityContext;
    protected final PortletWindowContext windowContext;
    protected Request request;
    protected final boolean prod;

    PortletRequestBridge(PortletBridgeContext context, Rq req, Rs resp, boolean prod) {
        String methodId = null;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(req.getParameterMap());
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry parameter = i.next();
            String key = (String)parameter.getKey();
            if (!key.startsWith("juzu.")) continue;
            if (((String)parameter.getKey()).equals("juzu.op")) {
                methodId = ((String[])parameter.getValue())[0];
            }
            i.remove();
        }
        this.context = context;
        this.req = req;
        this.resp = resp;
        this.methodId = methodId;
        this.parameters = parameters;
        this.httpContext = new PortletHttpContext((PortletRequest)req);
        this.securityContext = new PortletSecurityContext((PortletRequest)req);
        this.windowContext = new PortletWindowContext(this);
        this.prod = prod;
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        Object propertyValue = null;
        if (JuzuPortlet.PORTLET_MODE.equals(propertyType)) {
            propertyValue = this.req.getPortletMode();
        } else if (JuzuPortlet.WINDOW_STATE.equals(propertyType)) {
            propertyValue = this.req.getWindowState();
        } else if (RequestContext.METHOD_ID.equals(propertyType)) {
            propertyValue = this.methodId;
        }
        return propertyValue == null ? null : (T)propertyType.getType().cast(propertyValue);
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public final WindowContext getWindowContext() {
        return this.windowContext;
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.getRequestContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.getRequestContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getRequestContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.getFlashContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getFlashContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getFlashContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.getSessionContext(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.getSessionContext(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.getSessionContext(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    public void close() {
        ScopedContext context = this.getRequestContext(false);
        if (context != null) {
            context.close();
        }
    }

    protected final ScopedContext getRequestContext(boolean create) {
        ScopedContext context = (ScopedContext)this.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ScopedContext();
            this.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getFlashContext(boolean create) {
        ScopedContext context = null;
        PortletSession session = this.req.getPortletSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    protected final ScopedContext getSessionContext(boolean create) {
        ScopedContext context = null;
        PortletSession session = this.req.getPortletSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ScopedContext();
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public void begin(Request request) {
        this.request = request;
    }
}

