/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.inject.ScopedContext;
import juzu.impl.request.spi.RenderBridge;
import juzu.impl.request.spi.servlet.ServletBridgeContext;
import juzu.impl.request.spi.servlet.ServletMimeBridge;
import juzu.io.AppendableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRenderBridge
extends ServletMimeBridge
implements RenderBridge {
    ServletRenderBridge(ServletBridgeContext context, HttpServletRequest req, HttpServletResponse resp, String methodId, Map<String, String[]> parameters) {
        super(context, req, resp, methodId, parameters);
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void end(Response response) throws IllegalStateException, IOException {
        if (response instanceof Response.Render) {
            Iterable<Asset.Value> stylesheets;
            Iterable<Asset.Value> scripts;
            Response.Render render = (Response.Render)response;
            try {
                scripts = this.context.scriptManager.resolveAssets(render.getScripts());
                stylesheets = this.context.scriptManager.resolveAssets(render.getStylesheets());
            }
            catch (IllegalArgumentException e) {
                this.resp.sendError(500, e.getMessage());
                return;
            }
            this.resp.setContentType(render.getMimeType());
            PrintWriter writer = this.resp.getWriter();
            writer.println("<!DOCTYPE html>");
            writer.println("<html>");
            writer.println("<head>");
            for (Asset.Value stylesheet : stylesheets) {
                String path = stylesheet.getURI();
                int pos = path.lastIndexOf(46);
                String ext = pos == -1 ? "css" : path.substring(pos + 1);
                writer.print("<link rel=\"stylesheet\" type=\"text/");
                writer.print(ext);
                writer.print("\" href=\"");
                this.renderAssetURL(stylesheet, writer);
                writer.println("\"></link>");
            }
            for (Asset.Value script : scripts) {
                writer.print("<script type=\"text/javascript\" src=\"");
                this.renderAssetURL(script, writer);
                writer.println("\"></script>");
            }
            writer.println("</head>");
            writer.println("<body>");
            render.send(new AppendableStream(writer));
            writer.println("</body>");
            writer.println("</html>");
        }
    }

    private void renderAssetURL(Asset.Value asset, Appendable appendable) throws IOException {
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                if (!uri.startsWith("/")) {
                    appendable.append(this.req.getContextPath());
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case CLASSPATH: {
                appendable.append(this.req.getContextPath());
                if (!uri.startsWith("/")) {
                    appendable.append('/');
                }
                appendable.append(uri);
                break;
            }
            case EXTERNAL: {
                appendable.append(uri);
            }
        }
    }

    @Override
    public void close() {
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }
}

