/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.dialect.gtmpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.SectionType;
import juzu.impl.template.spi.juzu.dialect.gtmpl.Foo;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.TextConstant;
import juzu.impl.utils.Location;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyTemplateEmitter
extends DialectTemplateEmitter {
    private StringBuilder out = new StringBuilder();
    private List<TextConstant> textMethods = new ArrayList<TextConstant>();
    private int methodCount = 0;
    private HashMap<Integer, Foo> locationTable = new HashMap();
    private int lineNumber = 1;
    private Location pos = null;
    private int closureCount = 0;
    private int closureCountIndex = -1;
    private final int[] closureCountStack = new int[200];

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.out.toString());
        builder.append("\n");
        builder.append("public static class Constants\n");
        builder.append("{\n");
        for (TextConstant method : this.textMethods) {
            builder.append(method.getDeclaration()).append("\n");
        }
        builder.append("public static final Map<Integer, ").append(Foo.class.getName()).append("> TABLE = ");
        if (this.locationTable.isEmpty()) {
            builder.append("[:]");
        } else {
            builder.append("[\n");
            Iterator<Map.Entry<Integer, Foo>> i = this.locationTable.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Integer, Foo> entry = i.next();
                Foo text = entry.getValue();
                Location location = text.getPosition();
                builder.append(entry.getKey()).append(':').append("new ").append(Foo.class.getName()).append("(").append("new ").append(Location.class.getName()).append("(").append(location.getCol()).append(',').append(location.getLine()).append("),").append("'");
                Tools.escape(text.getValue(), builder);
                builder.append("')");
                if (i.hasNext()) {
                    builder.append(",\n");
                    continue;
                }
                builder.append(']');
            }
        }
        builder.append(";\n");
        builder.append("}\n");
        return builder.toString();
    }

    public GroovyTemplateStub build(String templateId) {
        final String script = this.toString();
        return new GroovyTemplateStub(templateId){

            public String getScript() {
                return script;
            }
        };
    }

    @Override
    public void startScriptlet(Location beginPosition) {
        this.pos = beginPosition;
    }

    @Override
    public void appendScriptlet(String scriptlet) {
        this.out.append(scriptlet);
        this.locationTable.put(this.lineNumber, new Foo(this.pos, scriptlet));
    }

    @Override
    public void endScriptlet() {
        this.out.append("\n");
        ++this.lineNumber;
    }

    @Override
    public void startExpression(Location beginPosition) {
        this.pos = beginPosition;
        this.out.append(";out.print(\"${");
    }

    @Override
    public void appendExpression(String expr) {
        this.out.append(expr);
        this.locationTable.put(this.lineNumber, new Foo(this.pos, expr));
    }

    @Override
    public void endExpression() {
        this.out.append("}\");\n");
        ++this.lineNumber;
    }

    @Override
    public void appendText(String text) {
        TextConstant m = new TextConstant("s" + this.methodCount++, text);
        this.out.append(";out.print(Constants.").append(m.name).append(");\n");
        this.textMethods.add(m);
        ++this.lineNumber;
    }

    @Override
    public void appendLineBreak(SectionType currentType, Location position) {
        this.pos = new Location(1, position.getLine() + 1);
        switch (currentType) {
            case SCRIPTLET: {
                this.out.append("\n");
                ++this.lineNumber;
                break;
            }
            case EXPR: {
                this.out.append("\n");
                ++this.lineNumber;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void url(String typeName, String methodName, List<String> args) {
        this.out.append(";out.print(");
        this.out.append(typeName);
        this.out.append(".");
        this.out.append(methodName);
        this.out.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.out.append(",");
            }
            String methodArg = args.get(i);
            this.out.append(methodArg);
        }
        this.out.append("));");
    }

    @Override
    public void openTag(String className, Map<String, String> args) {
        int n = this.closureCount++;
        this.closureCountStack[++this.closureCountIndex] = n;
        int count = n;
        this.out.append("; def closure").append(count).append(" = { ");
    }

    @Override
    public void closeTag(String className, Map<String, String> args) {
        int count = this.closureCountStack[this.closureCountIndex--];
        this.out.append("; } as juzu.template.Renderable;");
        this.out.append("; new ").append(className).append("().render(out.renderContext, closure").append(count).append(",");
        if (args == null || args.isEmpty()) {
            this.out.append("null");
        } else {
            this.out.append("[");
            int index = 0;
            for (Map.Entry<String, String> entry : args.entrySet()) {
                if (index++ > 0) {
                    this.out.append(",");
                }
                this.out.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\".toString()");
            }
            this.out.append("]");
        }
        this.out.append(");");
    }

    @Override
    public void tag(String tagName, Map<String, String> args) {
    }
}

