/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import juzu.AmbiguousResolutionException;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.controller.descriptor.ControllerMethodResolver;
import juzu.impl.utils.Tools;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ControllerResolverTestCase
extends AbstractTestCase {
    @Test
    public void testResolveIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "default_method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.default_method.Default_methodApplication");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod method = (ControllerMethod)resolver.resolve(Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"index", (String)method.getName());
    }

    @Test
    public void testResolveAmbiguousIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "ambiguous_method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.ambiguous_method.Ambiguous_methodApplication");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        try {
            resolver.resolve(Collections.emptySet());
            ControllerResolverTestCase.fail();
        }
        catch (AmbiguousResolutionException e) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultControllerResolveIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.default_controller.Default_controllerApplication");
        Class<?> aClass = compiler.assertClass("application.resolver.default_controller.A");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod method = (ControllerMethod)resolver.resolve(Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ControllerResolverTestCase.assertSame(aClass, method.getMethod().getDeclaringClass());
    }

    @Test
    public void testOverload() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "overload");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.overload.OverloadApplication");
        Class<?> aClass = compiler.assertClass("application.resolver.overload.A");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set());
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set(), (Object)method.getArgumentNames());
        method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set((Object)"foo"));
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set((Object)"foo"), (Object)method.getArgumentNames());
        method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set((Object[])new String[]{"foo", "bar"}));
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getArgumentNames());
        method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set((Object)"bar"));
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getArgumentNames());
        method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set((Object)"bar"));
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getArgumentNames());
        method = (ControllerMethod)resolver.resolve(Phase.RENDER, "A.m", (Set)Tools.set((Object)"daa"));
        ControllerResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ControllerResolverTestCase.assertEquals((Object)Tools.set(), (Object)method.getArgumentNames());
    }

    @Test
    public void testResolution() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "method");
        compiler.assertCompile();
        Class<?> aClass = compiler.assertClass("application.resolver.method.A");
        Class<?> clazz = compiler.assertClass("application.resolver.method.MethodApplication");
        ApplicationDescriptor desc = (ApplicationDescriptor)clazz.getField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod cm1_ = desc.getController().getMethod(aClass, "noArg", new Class[0]);
        ControllerMethod cm2_ = desc.getController().getMethod(aClass, "fooArg", new Class[]{String.class});
        ControllerMethod cm1 = (ControllerMethod)resolver.resolve(Phase.RENDER, cm1_.getId(), cm1_.getArgumentNames());
        ControllerResolverTestCase.assertNotNull((Object)cm1);
        ControllerResolverTestCase.assertEquals((String)"noArg", (String)cm1.getName());
        ControllerMethod cm2 = (ControllerMethod)resolver.resolve(Phase.RENDER, cm2_.getId(), cm2_.getArgumentNames());
        ControllerResolverTestCase.assertNotNull((Object)cm2);
        ControllerResolverTestCase.assertEquals((String)"fooArg", (String)cm2.getName());
    }

    @Test
    public void testTemplate() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.default_controller.Default_controllerApplication");
        Class<?> aClass = compiler.assertClass("application.resolver.default_controller.A");
        Class<?> bClass = compiler.assertClass("application.resolver.default_controller.B");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod method = (ControllerMethod)resolver.resolve((String)null, "index", Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (ControllerMethod)resolver.resolve("A", "index", Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (ControllerMethod)resolver.resolve("B", "index", Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), bClass);
    }

    @Test
    public void testTemplateResolveMethod() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("application", "resolver", "method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("application.resolver.method.MethodApplication");
        Class<?> aClass = compiler.assertClass("application.resolver.method.A");
        ApplicationDescriptor desc = (ApplicationDescriptor)appClass.getDeclaredField("DESCRIPTOR").get(null);
        ControllerMethodResolver resolver = new ControllerMethodResolver(desc.getController());
        ControllerMethod method = (ControllerMethod)resolver.resolve((String)null, "noArg", Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"noArg", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (ControllerMethod)resolver.resolve((String)null, "fooArg", Collections.emptySet());
        ControllerResolverTestCase.assertEquals((String)"fooArg", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (ControllerMethod)resolver.resolve((String)null, "fooArg", Collections.singleton("foo"));
        ControllerResolverTestCase.assertEquals((String)"fooArg", (String)method.getName());
        ControllerResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (ControllerMethod)resolver.resolve((String)null, "fooArg", Collections.singleton("bar"));
        ControllerResolverTestCase.assertNull((Object)method);
    }
}

