/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import java.io.IOException;
import java.util.ArrayList;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RAMFileSystemTestCase
extends AbstractTestCase {
    @Test
    public void testLastModified() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        RAMFile fooTxt = fs.addFile((RAMPath)fs.getRoot(), "foo.txt").update("abc");
        long now = RAMFileSystemTestCase.waitForOneMillis();
        RAMFileSystemTestCase.assertTrue((fs.getLastModified((RAMPath)fooTxt) < now ? 1 : 0) != 0);
        RAMFileSystemTestCase.waitForOneMillis();
        fooTxt.update("def");
        RAMFileSystemTestCase.assertTrue((now < fs.getLastModified((RAMPath)fooTxt) ? 1 : 0) != 0);
    }

    @Test
    public void testCopy() throws IOException {
        RAMFileSystem src = new RAMFileSystem();
        src.addFile((RAMPath)src.getRoot(), "foo").update("foo1");
        src.addDir((RAMPath)src.getRoot(), "bar");
        src.addFile((RAMPath)src.getRoot(), "juu").update("juu1");
        src.addDir((RAMPath)src.getRoot(), "bii");
        src.addFile((RAMPath)src.getRoot(), "baa");
        RAMFileSystem dst = new RAMFileSystem();
        RAMDir dstRoot = dst.getRoot();
        dstRoot.addFile("juu").update("juu2");
        dstRoot.addDir("daa");
        dstRoot.addFile("bii");
        dstRoot.addDir("baa");
        src.copy((ReadWriteFileSystem)dst);
        RAMPath bar = dstRoot.getChild("bar");
        RAMFileSystemTestCase.assertNotNull((Object)bar);
        RAMFileSystemTestCase.assertTrue((boolean)dst.isDir(bar));
        RAMPath foo = dstRoot.getChild("foo");
        RAMFileSystemTestCase.assertNotNull((Object)foo);
        RAMFileSystemTestCase.assertTrue((boolean)dst.isFile(foo));
        ArrayList children = Tools.list((Iterable)dstRoot.getChildren());
        RAMFileSystemTestCase.assertEquals((int)5, (int)children.size());
        RAMFile juu = (RAMFile)dstRoot.getChild("juu");
        RAMFileSystemTestCase.assertEquals((String)"juu1", (String)((Object)juu.getContent().getCharSequence()).toString());
        RAMFileSystemTestCase.assertEquals((long)src.getContent(src.getChild((RAMPath)src.getRoot(), "juu")).getLastModified(), (long)juu.getContent().getLastModified());
        RAMPath bii = dstRoot.getChild("bii");
        RAMFileSystemTestCase.assertNotNull((Object)bii);
        RAMFileSystemTestCase.assertTrue((boolean)(bii instanceof RAMDir));
        RAMPath baa = dstRoot.getChild("baa");
        RAMFileSystemTestCase.assertNotNull((Object)baa);
        RAMFileSystemTestCase.assertTrue((boolean)(baa instanceof RAMFile));
    }
}

