/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.JavaFile;
import org.junit.Test;

public class ParamTestCase
extends AbstractTestCase {
    private static JSON expectedJSON = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Class[fqn=model.meta.param.A]").list("methods", (Object[])new JSON[]{JSON.json().set("handle", (Object)"ElementHandle.Method[fqn=model.meta.param.A,name=index,parameterTypes[model.meta.param.Bean]]").set("id", null).set("name", (Object)"index").set("phase", (Object)"RENDER").list("parameters", (Object[])new JSON[]{JSON.json().set("name", (Object)"bean").set("declaredType", (Object)"model.meta.param.Bean").set("type", (Object)"ElementHandle.Class[fqn=model.meta.param.Bean]").set("cardinality", (Object)"SINGLE")})})}).set("fqn", (Object)"model.meta.param.ParamApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.param]").list("templates")}));

    @Test
    public void testBuild() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "param");
        helper.assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        ParamTestCase.assertEquals(expectedJSON, mm.toJSON());
    }

    @Test
    public void testParam() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "param");
        helper.assertCompile();
        JavaFile<File> file = helper.assertJavaFile("model", "meta", "param", "Bean.java");
        ClassOrInterfaceDeclaration bean = file.assertDeclaration();
        AnnotationExpr annotation = (AnnotationExpr)bean.getAnnotations().get(0);
        bean.getAnnotations().clear();
        file.assertSave();
        List<CompilationError> errors = helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).failCompile();
        ParamTestCase.assertEquals((int)1, (int)errors.size());
        bean.getAnnotations().add(annotation);
        file.assertSave();
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        ParamTestCase.assertEquals(expectedJSON, mm.toJSON());
    }
}

