/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class PathTestCase
extends AbstractTestCase {
    @Test
    public void testBuild() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "path");
        helper.assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.path.PathApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.path]").list("templates", (Object[])new JSON[]{JSON.json().set("path", (Object)"foo.gtmpl").list("refs")})}));
        PathTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testChangeValue() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "path");
        helper.assertCompile();
        File a = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "A.java"});
        Tools.write((String)Tools.read((File)a).replace("foo.gtmpl", "bar.gtmpl"), (File)a);
        File foo = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "templates", "foo.gtmpl"});
        File bar = new File(foo.getParentFile(), "bar.gtmpl");
        PathTestCase.assertTrue((boolean)foo.renameTo(bar));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.path.PathApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.path]").list("templates", (Object[])new JSON[]{JSON.json().set("path", (Object)"bar.gtmpl").list("refs")})}));
        PathTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testRemoveAnnotation() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "path");
        helper.assertCompile();
        File a = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "A.java"});
        Tools.write((String)Tools.read((File)a).replace("@Path(\"foo.gtmpl\")", ""), (File)a);
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.path.PathApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta.path]").list("templates")}));
        PathTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testPathRemoveApplication() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "path");
        helper.assertCompile();
        PathTestCase.assertDelete((File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "package-info.java"}));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values"));
        PathTestCase.assertEquals(expected, mm.toJSON());
    }

    @Test
    public void testRefactorApplication() throws Exception {
        CompilerAssert<File, File> helper = this.incrementalCompiler("model", "meta", "path");
        helper.assertCompile();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModel mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)ser);
        mm.getQueue().clear();
        Tools.serialize((Serializable)mm, (File)ser);
        File pkg = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "package-info.java"});
        File dst = new File(pkg.getParentFile().getParentFile(), pkg.getName());
        PathTestCase.assertTrue((boolean)pkg.renameTo(dst));
        pkg = dst;
        File templates = (File)helper.getSourcePath().getPath(new String[]{"model", "meta", "path", "templates"});
        File newtemplates = new File(templates.getParentFile().getParentFile(), templates.getName());
        PathTestCase.assertTrue((boolean)templates.renameTo(newtemplates));
        Tools.write((String)Tools.read((File)pkg).replace("package model.meta.path;", "package model.meta;"), (File)pkg);
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        mm = (MetaModel)Tools.unserialize(MetaModel.class, (File)((File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"})));
        JSON expected = JSON.json().set("applications", (Object)JSON.json().list("values", (Object[])new JSON[]{JSON.json().list("controllers").set("fqn", (Object)"model.meta.MetaApplication").set("handle", (Object)"ElementHandle.Package[qn=model.meta]").list("templates", (Object[])new JSON[]{JSON.json().set("path", (Object)"foo.gtmpl").list("refs")})}));
        PathTestCase.assertEquals(expected, mm.toJSON());
        List events = mm.getQueue().clear();
        PathTestCase.assertEquals((int)4, (int)events.size());
        PathTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        PathTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(1)).getType());
        PathTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(2)).getType());
        PathTestCase.assertEquals((int)0, (int)((MetaModelEvent)events.get(3)).getType());
    }
}

