/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.utils.QN;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class QN2TestCase
extends AbstractTestCase {
    @Test
    public void testIAE() {
        this.assertIAE(".");
        this.assertIAE(".a");
        this.assertIAE("a.");
        this.assertIAE("a..b");
        this.assertIAE("ab..c");
    }

    private void assertIAE(String value) {
        try {
            QN.parse((CharSequence)value);
            QN2TestCase.fail((String)("Was expecting " + value + " to fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValues() {
        this.assertQN("a.b", "a", "b");
        this.assertQN("a.b.c", "a", "b", "c");
    }

    private void assertQN(String value, String ... names) {
        QN qn = QN.parse((CharSequence)value);
        ArrayList testNames = Tools.list((Iterable)qn);
        QN2TestCase.assertEquals(Arrays.asList(names), testNames);
        QN2TestCase.assertEquals((String)value, (String)qn.getValue());
    }

    @Test
    public void testEmpty() {
        QN empty = QN.parse((CharSequence)"");
        QN2TestCase.assertEquals((int)0, (int)empty.size());
        QN2TestCase.assertEquals((int)0, (int)empty.length());
        QN2TestCase.assertEquals(Collections.emptyList(), Tools.list((Iterable)empty));
        QN2TestCase.assertNull((Object)empty.getParent());
        QN2TestCase.assertEquals((String)"", (String)empty.getValue());
    }

    @Test
    public void testSimple() {
        QN simple = QN.parse((CharSequence)"a");
        QN2TestCase.assertEquals((int)1, (int)simple.size());
        QN2TestCase.assertEquals((int)1, (int)simple.length());
        QN2TestCase.assertEquals(Collections.singletonList("a"), Tools.list((Iterable)simple));
        QN parent = simple.getParent();
        QN2TestCase.assertEquals((int)0, (int)parent.size());
        QN2TestCase.assertEquals((int)0, (int)parent.length());
        QN2TestCase.assertEquals((String)"a", (String)simple.getValue());
    }

    @Test
    public void testAppend() {
        this.assertAppend("a.b", "a", "b");
        this.assertAppend("a.b.c", "a.b", "c");
        try {
            QN.parse((CharSequence)"a").append(new String[]{""});
            QN2TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            QN.parse((CharSequence)"a").append(new String[]{"a.b"});
            QN2TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            QN.parse((CharSequence)"a").append(new String[]{null});
            QN2TestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            QN.parse((CharSequence)"a").append((String[])null);
            QN2TestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void assertAppend(String expected, String qn, String simpleName) {
        QN parsed = QN.parse((CharSequence)qn);
        QN appended = parsed.append(new String[]{simpleName});
        QN2TestCase.assertEquals((String)expected, (String)appended.getValue());
        QN2TestCase.assertEquals((int)appended.size(), (int)(parsed.size() + 1));
    }

    @Test
    public void testPrefix() {
        this.assertPrefix("", "");
        this.assertPrefix("", "a");
        this.assertPrefix("", "a.b");
        this.assertPrefix("", "a.b.c");
        this.assertNotPrefix("a", "");
        this.assertPrefix("a", "a");
        this.assertPrefix("a", "a.b");
        this.assertPrefix("a", "a.b.c");
        this.assertNotPrefix("a.b", "");
        this.assertNotPrefix("a.b", "a");
        this.assertPrefix("a.b", "a.b");
        this.assertPrefix("a.b", "a.b.c");
        this.assertNotPrefix("a.b.c", "");
        this.assertNotPrefix("a.b.c", "a");
        this.assertNotPrefix("a.b.c", "a.b");
        this.assertPrefix("a.b.c", "a.b.c");
    }

    private void assertPrefix(String prefix, String s) {
        QN2TestCase.assertTrue((boolean)QN.parse((CharSequence)prefix).isPrefix(QN.parse((CharSequence)s)));
    }

    private void assertNotPrefix(String prefix, String s) {
        QN2TestCase.assertFalse((boolean)QN.parse((CharSequence)prefix).isPrefix(QN.parse((CharSequence)s)));
    }

    @Test
    public void testParent() {
        QN abc = QN.parse((CharSequence)"a.b.c");
        QN ab = abc.getParent();
        QN2TestCase.assertNotNull((Object)ab);
        QN2TestCase.assertEquals((Object)QN.parse((CharSequence)"a.b"), (Object)ab);
        QN a = ab.getParent();
        QN2TestCase.assertEquals((Object)QN.parse((CharSequence)"a"), (Object)a);
        QN empty = a.getParent();
        QN2TestCase.assertEquals((int)0, (int)empty.size());
        QN2TestCase.assertEquals((int)0, (int)empty.length());
    }
}

