/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.inject.Provider;
import junit.framework.Assert;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.Compiler;
import juzu.impl.compiler.CompilerConfig;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompileStrategy<I, O> {
    final SimpleFileSystem<?> classPath;
    final ReadWriteFileSystem<I> sourcePath;
    final ReadWriteFileSystem<O> sourceOutput;
    final ReadWriteFileSystem<O> classOutput;
    Provider<? extends Processor> processorFactory;
    final CompilerConfig config;
    Compiler compiler;
    private static final Pattern javaFilePattern = Pattern.compile("(.+)\\.java");

    public CompileStrategy(SimpleFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput, Provider<? extends Processor> processorFactory) {
        this.classPath = classPath;
        this.sourcePath = sourcePath;
        this.sourceOutput = sourceOutput;
        this.classOutput = classOutput;
        this.processorFactory = processorFactory;
        this.config = new CompilerConfig().force(true);
    }

    final Compiler.Builder compiler() {
        Compiler.Builder builder = Compiler.builder();
        builder.addClassPath(this.classPath);
        builder.sourcePath(this.sourcePath);
        builder.sourceOutput(this.sourceOutput);
        builder.classOutput(this.classOutput);
        builder.config(this.config);
        return builder;
    }

    abstract List<CompilationError> compile() throws IOException;

    abstract void addClassPath(ReadFileSystem<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Batch<I, O>
    extends CompileStrategy<I, O> {
        public Batch(SimpleFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput, Provider<? extends Processor> processorFactory) {
            super(classPath, sourcePath, sourceOutput, classOutput, processorFactory);
        }

        @Override
        List<CompilationError> compile() throws IOException {
            Compiler.Builder builder = this.compiler();
            this.compiler = builder.build(this.processorFactory != null ? (Processor)this.processorFactory.get() : null);
            return this.compiler.compile();
        }

        @Override
        void addClassPath(ReadFileSystem<?> classPath) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Incremental<I, O>
    extends CompileStrategy<I, O> {
        final LinkedList<ReadFileSystem<?>> classPath = new LinkedList();
        final FileSystemScanner<I> scanner;

        public Incremental(SimpleFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput, Provider<? extends Processor> processorFactory) {
            super(classPath, sourcePath, sourceOutput, classOutput, processorFactory);
            this.scanner = FileSystemScanner.createHashing(sourcePath);
        }

        @Override
        List<CompilationError> compile() throws IOException {
            Compiler.Builder builder = this.compiler();
            ArrayList<String> toCompile = new ArrayList<String>();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry entry : this.scanner.scan().entrySet()) {
                String path = (String)entry.getKey();
                if (!path.endsWith(".java")) continue;
                switch ((Change)entry.getValue()) {
                    case REMOVE: {
                        toDelete.add(path);
                        break;
                    }
                    case ADD: {
                        toCompile.add(path);
                        break;
                    }
                    case UPDATE: {
                        toCompile.add(path);
                        toDelete.add(path);
                    }
                }
            }
            for (String string : toDelete) {
                Matcher matcher = javaFilePattern.matcher(string);
                Assert.assertTrue((boolean)matcher.matches());
                String path = matcher.group(1) + ".class";
                String[] names = Tools.split((CharSequence)path, (char)'/');
                Object clazz = this.classOutput.getPath(names);
                if (clazz == null) continue;
                this.classOutput.removePath(clazz);
            }
            for (ReadFileSystem readFileSystem : this.classPath) {
                builder.addClassPath((SimpleFileSystem)readFileSystem);
            }
            System.out.println("Compiling " + toCompile);
            this.compiler = builder.build(this.processorFactory != null ? (Processor)this.processorFactory.get() : null);
            return this.compiler.compile(toCompile.toArray(new String[toCompile.size()]));
        }

        @Override
        void addClassPath(ReadFileSystem<?> classPath) {
            this.classPath.add(classPath);
        }
    }
}

