/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.jar.JarFile;
import juzu.impl.application.ApplicationBootstrap;
import juzu.impl.application.ApplicationContext;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.application.ApplicationException;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.jar.JarFileSystem;
import juzu.impl.inject.spi.InjectBuilder;
import juzu.impl.request.spi.RequestBridge;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockApplication<P> {
    private final InjectBuilder bootstrap;
    private final ReadFileSystem<P> classes;
    final ClassLoader classLoader;
    ApplicationContext context;
    private ApplicationBootstrap boot;
    private final ApplicationDescriptor descriptor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MockApplication(ReadFileSystem<P> classes, ClassLoader classLoader, InjectBuilder bootstrap) throws Exception {
        DiskFileSystem libs;
        Object f = classes.getPath(Arrays.asList("juzu", "config.json"));
        if (f == null) {
            throw new Exception("Cannot find config properties");
        }
        URL url = classes.getURL(f);
        String s = Tools.read((URL)url);
        JSON props = (JSON)JSON.parse((String)s);
        if (props.names().size() != 1) {
            throw AbstractTestCase.failure("Could not find an application to start " + props);
        }
        String name = (String)props.names().iterator().next();
        String fqn = props.getString(name);
        URL location = ApplicationBootstrap.class.getProtectionDomain().getCodeSource().getLocation();
        String protocol = location.getProtocol();
        if (!"file".equals(protocol)) throw AbstractTestCase.failure("Could not create file system from location " + location);
        File file = new File(location.toURI());
        if (file.isDirectory()) {
            libs = new DiskFileSystem(file);
        } else {
            if (!file.isFile() || !file.getName().endsWith(".jar")) throw AbstractTestCase.failure("Could not create file system from location " + location);
            libs = new JarFileSystem(new JarFile(file));
        }
        Class<?> clazz = classLoader.loadClass(fqn);
        Field field = clazz.getDeclaredField("DESCRIPTOR");
        ApplicationDescriptor descriptor = (ApplicationDescriptor)field.get(null);
        bootstrap.addFileSystem(classes);
        bootstrap.addFileSystem((ReadFileSystem)libs);
        bootstrap.setClassLoader(classLoader);
        this.classes = classes;
        this.classLoader = classLoader;
        this.bootstrap = bootstrap;
        this.descriptor = descriptor;
    }

    public MockApplication<P> init() throws Exception {
        ApplicationBootstrap boot = new ApplicationBootstrap(this.bootstrap, this.descriptor);
        boot.start();
        this.context = boot.getContext();
        this.boot = boot;
        return this;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public MockApplication<P> declareBean(Class<?> beanClass) throws ClassNotFoundException {
        this.bootstrap.declareBean(beanClass, null, null, null);
        return this;
    }

    public MockApplication<P> declareBean(String className) throws ClassNotFoundException {
        return this.declareBean(this.classLoader.loadClass(className));
    }

    public <T> MockApplication<P> bindBean(Class<T> type, Iterable<Annotation> qualifiers, T bean) {
        this.bootstrap.bindBean(type, qualifiers, bean);
        return this;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    void invoke(RequestBridge bridge) throws ApplicationException {
        this.context.invoke(bridge);
    }

    public MockClient client() {
        return new MockClient(this);
    }
}

