/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.Formatter;
import java.util.Locale;
import juzu.impl.compiler.MessageCode;

public class CompilationMessage {
    private final MessageCode code;
    private final Object[] arguments;

    public CompilationMessage(MessageCode code, Object ... arguments) {
        this.code = code;
        this.arguments = arguments;
    }

    public MessageCode getCode() {
        return this.code;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public StringBuilder format(StringBuilder sb, boolean formal) {
        if (formal) {
            sb = sb.append("[").append(this.code.getKey()).append("](");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(String.valueOf(this.arguments[i]));
            }
            sb.append(")");
        } else {
            new Formatter(sb).format(Locale.getDefault(), this.code.getMessage(), this.arguments).flush();
        }
        return sb;
    }

    public String toFormalString() {
        return this.format(new StringBuilder(), true).toString();
    }

    public String toDisplayString() {
        return this.format(new StringBuilder(), false).toString();
    }

    public String toString() {
        return this.format(new StringBuilder("CompilationMessage["), false).append("]").toString();
    }
}

