/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.util.ArrayList;
import java.util.List;
import juzu.Scope;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.Plugin;
import juzu.impl.plugin.binding.BindingDescriptor;
import juzu.impl.utils.JSON;

public class BindingPlugin
extends Plugin {
    public BindingPlugin() {
        super("binding");
    }

    public Descriptor init(ClassLoader loader, JSON config) throws Exception {
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        List<JSON> bindings = config.getList("bindings", JSON.class);
        for (JSON binding : bindings) {
            String value = binding.getString("value");
            String scope = binding.getString("scope");
            String implementation = binding.getString("implementation");
            Class<?> valueType = loader.loadClass(value);
            Class<?> implementationType = implementation != null ? loader.loadClass(implementation) : null;
            Scope beanScope = scope != null ? Scope.valueOf(scope.toUpperCase()) : null;
            BeanDescriptor bean = new BeanDescriptor(valueType, beanScope, null, implementationType);
            beans.add(bean);
        }
        return new BindingDescriptor(beans);
    }
}

