/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.metamodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.Path;
import juzu.impl.application.metamodel.ApplicationMetaModel;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.inject.Export;
import juzu.impl.template.TemplatePlugin;
import juzu.impl.template.metadata.TemplateDescriptor;
import juzu.impl.template.metamodel.ModelTemplateProcessContext;
import juzu.impl.template.metamodel.TemplateMetaModel;
import juzu.impl.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.TemplateProvider;
import juzu.impl.utils.Content;
import juzu.impl.utils.FQN;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Path;
import juzu.impl.utils.Tools;
import juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(TemplateResolver.class);
    private final ApplicationMetaModel application;
    private Map<juzu.impl.utils.Path, juzu.impl.template.spi.Template<?>> templates;
    private Set<juzu.impl.utils.Path> emitted;
    private Map<FQN, FileObject> stubCache;
    private Map<FQN, FileObject> classCache;

    public TemplateResolver(ApplicationMetaModel application) {
        if (application == null) {
            throw new NullPointerException();
        }
        this.application = application;
        this.templates = new HashMap();
        this.emitted = new HashSet<juzu.impl.utils.Path>();
        this.stubCache = new HashMap<FQN, FileObject>();
        this.classCache = new HashMap<FQN, FileObject>();
    }

    public Collection<juzu.impl.template.spi.Template<?>> getTemplates() {
        return this.templates.values();
    }

    public void removeTemplate(juzu.impl.utils.Path path) {
        this.templates.remove(path);
    }

    public void prePassivate() {
        log.log("Evicting cache " + this.emitted);
        this.emitted.clear();
        this.stubCache.clear();
        this.classCache.clear();
    }

    public void process(TemplateMetaModelPlugin plugin, ProcessingContext context) throws CompilationException {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        log.log("Synchronizing existing templates " + this.templates.keySet());
        Iterator<juzu.impl.template.spi.Template<?>> i = this.templates.values().iterator();
        while (i.hasNext()) {
            juzu.impl.template.spi.Template<?> template = i.next();
            Path.Absolute absolute = metaModel.resolve(template.getPath());
            Content content = context.resolveResource(this.application.getHandle(), absolute);
            if (content == null) {
                i.remove();
                log.log("Detected template removal " + template.getPath());
                continue;
            }
            if (content.getLastModified() > template.getLastModified()) {
                i.remove();
                log.log("Detected stale template " + template.getPath());
                continue;
            }
            log.log("Template " + template.getPath() + " is valid");
        }
        log.log("Building missing templates");
        HashMap copy = new HashMap(this.templates);
        for (TemplateMetaModel templateMetaModel : metaModel) {
            juzu.impl.template.spi.Template template = (juzu.impl.template.spi.Template)copy.get(templateMetaModel.getPath());
            if (template != null) continue;
            log.log("Compiling template " + templateMetaModel.getPath());
            ModelTemplateProcessContext compiler = new ModelTemplateProcessContext(templateMetaModel, new HashMap(copy), context);
            Collection<juzu.impl.template.spi.Template<?>> resolved = compiler.resolve(templateMetaModel);
            for (juzu.impl.template.spi.Template template2 : resolved) {
                copy.put(template2.getPath(), template2);
            }
        }
        this.templates = copy;
        for (juzu.impl.template.spi.Template template : this.templates.values()) {
            juzu.impl.utils.Path originPath = template.getOriginPath();
            TemplateMetaModel templateMeta = metaModel.get(originPath);
            LinkedHashSet<FQN> types = new LinkedHashSet<FQN>();
            for (TemplateRefMetaModel templateRefMetaModel : templateMeta.getRefs()) {
                ElementHandle.Field handle = templateRefMetaModel.getHandle();
                types.add(handle.getFQN());
            }
            Element[] elements = new Element[types.size()];
            boolean bl = false;
            for (FQN type : types) {
                elements[++var11_18] = context.getTypeElement(type.getName());
            }
            this.resolveStub(template, plugin, context, elements);
            this.resolvedQualified(template, context, elements);
            this.resolveScript(template, plugin, context, elements);
        }
    }

    private <M extends Serializable> void resolveScript(final juzu.impl.template.spi.Template<M> template, final TemplateMetaModelPlugin plugin, final ProcessingContext context, final Element[] elements) {
        context.executeWithin(elements[0], new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                TemplatesMetaModel metaModel = TemplateResolver.this.application.getChild(TemplatesMetaModel.KEY);
                TemplateProvider provider = plugin.providers.get(template.getPath().getExt());
                if (!TemplateResolver.this.emitted.contains(template.getPath())) {
                    try {
                        Object model = template.getModel();
                        EmitContext emitCtx = new EmitContext();
                        CharSequence res = provider.emit(emitCtx, model);
                        if (res != null) {
                            Path.Absolute absolute = metaModel.resolve(template.getPath());
                            FileObject scriptFile = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute.as(provider.getTargetExtension()), elements);
                            Writer writer = null;
                            try {
                                writer = scriptFile.openWriter();
                                writer.write(((Object)res).toString());
                            }
                            finally {
                                Tools.safeClose(writer);
                            }
                            log.log("Generated template script " + template.getPath() + " as " + scriptFile.toUri() + " with originating elements " + Arrays.asList(elements));
                        }
                        TemplateResolver.this.emitted.add(template.getPath());
                    }
                    catch (IOException e) {
                        throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_SCRIPT.failure(e, template.getPath());
                    }
                }
                log.log("Template " + template.getPath() + " was found in cache");
                return null;
            }
        });
    }

    private <M extends Serializable> void resolvedQualified(juzu.impl.template.spi.Template<M> template, ProcessingContext context, Element[] elements) {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        juzu.impl.utils.Path path = template.getPath();
        Path.Absolute absolute = metaModel.resolve(path);
        if (this.classCache.containsKey(path.getFQN())) {
            log.log("Template class " + path + " was found in cache");
            return;
        }
        Writer writer = null;
        try {
            JavaFileObject classFile = context.createSourceFile(absolute.getFQN(), elements);
            writer = classFile.openWriter();
            writer.append("package ").append(absolute.getQN()).append(";\n");
            writer.append("import ").append(Tools.getImport(Path.class)).append(";\n");
            writer.append("import ").append(Tools.getImport(Export.class)).append(";\n");
            writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
            writer.append("import ").append(Tools.getImport(TemplateDescriptor.class)).append(";\n");
            writer.append("import javax.inject.Inject;\n");
            writer.append("import ").append(Tools.getImport(TemplatePlugin.class)).append(";\n");
            writer.append("@Generated({})\n");
            writer.append("@Export\n");
            writer.append("@Path(\"").append(path.getValue()).append("\")\n");
            writer.append("public class ").append(path.getRawName()).append(" extends ").append(Template.class.getName()).append("\n");
            writer.append("{\n");
            writer.append("@Inject\n");
            writer.append("public ").append(path.getRawName()).append("(").append(TemplatePlugin.class.getSimpleName()).append(" templatePlugin").append(")\n");
            writer.append("{\n");
            writer.append("super(templatePlugin, \"").append(path.getValue()).append("\");\n");
            writer.append("}\n");
            writer.append("public static final TemplateDescriptor DESCRIPTOR = new TemplateDescriptor(").append(absolute.getFQN().getName()).append(".class);\n");
            String baseBuilderName = Tools.getImport(Template.Builder.class);
            if (template.getParameters() != null) {
                writer.append("public Builder with() {\n");
                writer.append("return new Builder();\n");
                writer.append("}\n");
                writer.append("public class Builder extends ").append(baseBuilderName).append("\n");
                writer.append("{\n");
                for (String paramName : template.getParameters()) {
                    writer.append("public Builder ").append(paramName).append("(Object ").append(paramName).append(") {\n");
                    writer.append("set(\"").append(paramName).append("\",").append(paramName).append(");\n");
                    writer.append("return this;\n");
                    writer.append("}\n");
                }
                writer.append("}\n");
            } else {
                writer.append("public ").append(baseBuilderName).append(" with() {\n");
                writer.append("return new ").append(baseBuilderName).append("();\n");
                writer.append("}\n");
            }
            writer.append("}\n");
            this.classCache.put(path.getFQN(), classFile);
            log.log("Generated template class " + path + " as " + classFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_CLASS.failure(e, elements[0], path);
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }

    private void resolveStub(juzu.impl.template.spi.Template<?> template, TemplateMetaModelPlugin plugin, ProcessingContext context, Element[] elements) {
        if (this.stubCache.containsKey(template.getPath().getFQN())) {
            log.log("Template strub " + template.getPath().getFQN() + " was found in cache");
            return;
        }
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        Path.Absolute absolute = metaModel.resolve(template.getPath());
        FQN stubFQN = new FQN(absolute.getFQN().getName() + "_");
        TemplateProvider provider = plugin.providers.get(template.getPath().getExt());
        Writer writer = null;
        try {
            JavaFileObject stubFile = context.createSourceFile(stubFQN, elements);
            writer = stubFile.openWriter();
            writer.append("package ").append(stubFQN.getPackageName()).append(";\n");
            writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
            writer.append("@Generated({\"").append(stubFQN.getName()).append("\"})\n");
            writer.append("public class ").append(stubFQN.getSimpleName()).append(" extends ").append(provider.getTemplateStubType().getName()).append(" {\n");
            writer.append("}");
            this.stubCache.put(template.getPath().getFQN(), stubFile);
            log.log("Generating template stub " + stubFQN.getName() + " as " + stubFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_STUB.failure(e, elements[0], template.getPath());
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }
}

