/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private static final Iterable EMPTY_ITERABLE = new Iterable(){

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }
    };
    public static Pattern EMPTY_NO_RECURSE = Pattern.compile("");
    public static Pattern EMPTY_RECURSE = Pattern.compile(".*");

    public static Pattern getPackageMatcher(String packageName, boolean recurse) {
        if (packageName.length() == 0) {
            return recurse ? EMPTY_RECURSE : EMPTY_NO_RECURSE;
        }
        String regex = recurse ? Pattern.quote(packageName) + "(\\..*)?" : Pattern.quote(packageName);
        return Pattern.compile(regex);
    }

    public static void escape(CharSequence s, StringBuilder appendable) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\'') {
                appendable.append("\\'");
                continue;
            }
            if (c == '\r') continue;
            appendable.append(c);
        }
    }

    public static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Method safeGetMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <E> void addAll(Collection<? super E> collection, Iterable<E> elements) {
        for (E element : elements) {
            collection.add(element);
        }
    }

    public static <T> List<T> safeUnmodifiableList(T ... list) {
        return Tools.safeUnmodifiableList(Arrays.asList(list));
    }

    public static <T> List<T> safeUnmodifiableList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(in.available());
            Tools.copy(in, baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Tools.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String content, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Tools.copy(new ByteArrayInputStream(content.getBytes()), out);
        }
        finally {
            Tools.safeClose(out);
        }
    }

    public static String read(URL url) throws IOException {
        return Tools.read(url.openStream());
    }

    public static String read(File f) throws IOException {
        return Tools.read(new FileInputStream(f));
    }

    public static String read(InputStream in) throws IOException {
        return Tools.read(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, String charsetName) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tools.copy(in, baos);
            String string = baos.toString();
            return string;
        }
        finally {
            Tools.safeClose(in);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int l;
        byte[] buffer = new byte[256];
        while ((l = in.read(buffer)) != -1) {
            out.write(buffer, 0, l);
        }
    }

    public static String unquote(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("Can't unquote null string");
        }
        if (s.length() > 1) {
            char c1 = s.charAt(0);
            char c2 = s.charAt(s.length() - 1);
            if ((c1 == '\'' || c1 == '\"') && c1 == c2) {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    public static String join(char separator, String ... names) {
        switch (names.length) {
            case 0: {
                return "";
            }
            case 1: {
                return names[0];
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static String getImport(Class<?> clazz) {
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Cannot use local or anonymous class");
        }
        if (clazz.isMemberClass()) {
            StringBuilder sb = new StringBuilder();
            while (clazz.isMemberClass()) {
                sb.insert(0, clazz.getSimpleName());
                sb.insert(0, '.');
                clazz = clazz.getEnclosingClass();
            }
            sb.insert(0, clazz.getSimpleName());
            String pkg = clazz.getPackage().getName();
            if (pkg.length() > 0) {
                sb.insert(0, '.');
                sb.insert(0, pkg);
            }
            return sb.toString();
        }
        return clazz.getName();
    }

    public static <E> HashSet<E> addToHashSet(Set<E> set, E e) {
        HashSet<E> hashSet = set instanceof HashSet ? (HashSet<E>)set : new HashSet<E>(set);
        hashSet.add(e);
        return hashSet;
    }

    public static <E> ArrayList<E> addToArrayList(List<E> list, E e) {
        ArrayList<E> arrayList = list instanceof ArrayList ? (ArrayList<E>)list : new ArrayList<E>(list);
        arrayList.add(e);
        return arrayList;
    }

    public static <E> HashSet<E> set() {
        return new HashSet();
    }

    public static <E> HashSet<E> set(E element) {
        HashSet<E> set = new HashSet<E>();
        set.add(element);
        return set;
    }

    public static <E> HashSet<E> set(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> set(Iterable<E> elements) {
        return Tools.set(elements.iterator());
    }

    public static <E> HashSet<E> set(Iterator<E> elements) {
        HashSet<E> list = new HashSet<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(Iterable<E> elements) {
        return Tools.list(elements.iterator());
    }

    public static <E> ArrayList<E> list(Iterator<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... elements) {
        ArrayList set = new ArrayList(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Iterable<E> iterable(final E ... elements) throws NullPointerException {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Tools.iterator(0, elements);
            }
        };
    }

    public static <E> Iterator<E> iterator(E ... elements) throws NullPointerException {
        return Tools.iterator(0, elements);
    }

    public static <E> Iterator<E> iterator(int from, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        if (elements == null) {
            throw new NullPointerException("No null element array accepted");
        }
        return Tools.iterator(from, elements.length, elements);
    }

    public static <E> Iterator<E> iterator(final int from, final int to, final E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        if (elements == null) {
            throw new NullPointerException("No null element array accepted");
        }
        if (from < 0) {
            throw new IndexOutOfBoundsException("From value " + from + " cannot be negative");
        }
        if (to > elements.length) {
            throw new IndexOutOfBoundsException("To value " + from + " cannot be greater than the array length " + elements.length);
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("From value " + from + " cannot be greater than the from value " + elements.length);
        }
        if (from == to) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<E>(){
            private int index;
            {
                this.index = from;
            }

            @Override
            public boolean hasNext() {
                return this.index < to;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return elements[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterator<E> emptyIterator() {
        Iterator iterator = EMPTY_ITERATOR;
        return iterator;
    }

    public static <E> Iterable<E> emptyIterable() {
        Iterable iterable = EMPTY_ITERABLE;
        return iterable;
    }

    public static <E> Iterator<E> append(final Iterator<E> iterator, final E ... elements) {
        return new Iterator<E>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return true;
                    }
                    this.index = 0;
                }
                return this.index < elements.length;
            }

            @Override
            public E next() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    this.index = 0;
                }
                if (this.index < elements.length) {
                    return elements[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S extends Serializable> S unserialize(Class<S> expectedType, File f) throws IOException, ClassNotFoundException {
        return (S)((Serializable)Tools.unserialize(expectedType, new FileInputStream(f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S unserialize(Class<S> expectedType, InputStream in) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object o = ois.readObject();
            S s = expectedType.cast(o);
            return s;
        }
        finally {
            Tools.safeClose(in);
        }
    }

    public static <S extends Serializable> void serialize(S value, File f) throws IOException {
        Tools.serialize(value, new FileOutputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void serialize(T value, OutputStream out) throws IOException {
        ObjectOutputStream ois = new ObjectOutputStream(out);
        try {
            ois.writeObject(value);
        }
        finally {
            Tools.safeClose(out);
        }
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static long parseISO8601(String date) {
        return DatatypeConverter.parseDateTime((String)date).getTimeInMillis();
    }

    public static String formatISO8601(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public static long handle(Element te) {
        long hash = 0L;
        for (Element element : te.getEnclosedElements()) {
            hash = 31L * hash + Tools.handle(element);
        }
        hash = 31L * hash + (long)te.getSimpleName().toString().hashCode();
        return hash;
    }

    public static String[] split(CharSequence s, char separator) {
        return Tools.foo(s, separator, 0, 0, 0);
    }

    public static String[] split(CharSequence s, char separator, int rightPadding) {
        if (rightPadding < 0) {
            throw new IllegalArgumentException("Right padding cannot be negative");
        }
        return Tools.foo(s, separator, 0, 0, rightPadding);
    }

    private static String[] foo(CharSequence s, char separator, int count, int from, int rightPadding) {
        int len = s.length();
        if (from < len) {
            String[] ret;
            int to;
            for (to = from; to < len && s.charAt(to) != separator; ++to) {
            }
            if (to == len - 1) {
                ret = new String[count + 2 + rightPadding];
                ret[count + 1] = "";
            } else {
                ret = to == len ? new String[count + 1 + rightPadding] : Tools.foo(s, separator, count + 1, to + 1, rightPadding);
            }
            ret[count] = from == to ? "" : ((Object)s.subSequence(from, to)).toString();
            return ret;
        }
        if (from == len) {
            return new String[count + rightPadding];
        }
        throw new AssertionError();
    }

    public static AnnotationMirror getAnnotation(Element element, String annotationFQN) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationFQN)) continue;
            return annotationMirror;
        }
        return null;
    }
}

