/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import juzu.impl.utils.Tools;
import juzu.impl.utils.Trie;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class ToolsTestCase
extends AbstractTestCase {
    @Test
    public void testEmptyNoRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"", (boolean)false);
        ToolsTestCase.assertTrue((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar").matches());
    }

    @Test
    public void testEmptyRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"", (boolean)true);
        ToolsTestCase.assertTrue((boolean)p.matcher("").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar").matches());
    }

    @Test
    public void testNoRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"foo", (boolean)false);
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foo.bar.juu").matches());
    }

    @Test
    public void testRecursePackageMatcher() {
        Pattern p = Tools.getPackageMatcher((String)"foo", (boolean)true);
        ToolsTestCase.assertTrue((boolean)p.matcher("foo").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar").matches());
        ToolsTestCase.assertTrue((boolean)p.matcher("foo.bar.juu").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("bar").matches());
        ToolsTestCase.assertFalse((boolean)p.matcher("foobar").matches());
    }

    @Test
    public void testUnquote() {
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)""));
        ToolsTestCase.assertEquals((String)"'", (String)Tools.unquote((String)"'"));
        ToolsTestCase.assertEquals((String)"\"", (String)Tools.unquote((String)"\""));
        ToolsTestCase.assertEquals((String)"'\"", (String)Tools.unquote((String)"'\""));
        ToolsTestCase.assertEquals((String)"\"'", (String)Tools.unquote((String)"\"'"));
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)"''"));
        ToolsTestCase.assertEquals((String)"", (String)Tools.unquote((String)"\"\""));
        ToolsTestCase.assertEquals((String)"a", (String)Tools.unquote((String)"'a'"));
        ToolsTestCase.assertEquals((String)"a", (String)Tools.unquote((String)"\"a\""));
        ToolsTestCase.assertEquals((String)"'a\"", (String)Tools.unquote((String)"'a\""));
        ToolsTestCase.assertEquals((String)"\"a'", (String)Tools.unquote((String)"\"a'"));
    }

    @Test
    public void testSplit() {
        ToolsTestCase.assertEquals(Collections.emptyList(), Arrays.asList(Tools.split((CharSequence)"", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a"), Arrays.asList(Tools.split((CharSequence)"a", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a", ""), Arrays.asList(Tools.split((CharSequence)"a.", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("", "a"), Arrays.asList(Tools.split((CharSequence)".a", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("", ""), Arrays.asList(Tools.split((CharSequence)".", (char)'.')));
        ToolsTestCase.assertEquals(Arrays.asList("a", "b"), Arrays.asList(Tools.split((CharSequence)"a.b", (char)'.')));
        String[] ret = Tools.split((CharSequence)"a.b", (char)'.', (int)1);
        ToolsTestCase.assertEquals((int)3, (int)ret.length);
        ToolsTestCase.assertEquals((String)"a", (String)ret[0]);
        ToolsTestCase.assertEquals((String)"b", (String)ret[1]);
        ToolsTestCase.assertEquals(null, (String)ret[2]);
        ret = Tools.split((CharSequence)"", (char)'.', (int)1);
        ToolsTestCase.assertEquals((int)1, (int)ret.length);
        ToolsTestCase.assertEquals(null, (String)ret[0]);
    }

    @Test
    public void testIteratorAppend() {
        Iterator i = Tools.append(Collections.emptyList().iterator(), (Object[])new Object[]{"foo"});
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
        i = Tools.append(Collections.singletonList("foo").iterator(), (Object[])new String[0]);
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
        i = Tools.append(Collections.singletonList("foo").iterator(), (Object[])new String[]{"bar"});
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"foo", i.next());
        ToolsTestCase.assertTrue((boolean)i.hasNext());
        ToolsTestCase.assertEquals((Object)"bar", i.next());
        ToolsTestCase.assertFalse((boolean)i.hasNext());
        ToolsTestCase.assertNoSuchElement(i);
    }

    @Test
    public void testTrieEmpty() {
        Trie trie = new Trie();
        ToolsTestCase.assertNull((Object)trie.getParent());
        ToolsTestCase.assertNull((Object)trie.getKey());
        ToolsTestCase.assertEquals(Collections.emptyList(), Tools.list((Iterable)trie.getPath()));
        ToolsTestCase.assertNull((Object)trie.value());
        ToolsTestCase.assertNull((Object)trie.value((Object)"foo"));
        ToolsTestCase.assertEquals((String)"foo", (String)((String)trie.value()));
        ToolsTestCase.assertEquals((String)"foo", (String)((String)trie.value((Object)"bar")));
        ToolsTestCase.assertEquals((String)"bar", (String)((String)trie.value()));
        ToolsTestCase.assertEquals((String)"bar", (String)((String)trie.value((Object)"juu")));
    }

    @Test
    public void testTrieAddKey() {
        Trie root = new Trie();
        Trie foo = root.add((Object)"foo");
        ToolsTestCase.assertSame((Object)foo, (Object)root.get((Object)"foo"));
        ToolsTestCase.assertSame((Object)foo, (Object)root.add((Object)"foo"));
        ToolsTestCase.assertSame((Object)root, (Object)foo.getParent());
    }

    @Test
    public void testTrieAddKeys() {
        Trie root = new Trie();
        Trie bar = root.add((Object[])new String[]{"foo", "bar"});
        Trie foo = bar.getParent();
        ToolsTestCase.assertSame((Object)foo, (Object)root.get((Object)"foo"));
        ToolsTestCase.assertSame((Object)foo, (Object)root.add((Object)"foo"));
        ToolsTestCase.assertSame((Object)root, (Object)foo.getParent());
        ToolsTestCase.assertSame((Object)bar, (Object)foo.get((Object)"bar"));
        ToolsTestCase.assertSame((Object)bar, (Object)foo.add((Object)"bar"));
    }

    @Test
    public void testTrieMerge() {
        Trie root1 = new Trie();
        Trie foo1 = root1.add((Object)"foo");
        Trie bar1 = foo1.add((Object)"bar");
        Trie root2 = new Trie();
        Trie foo2 = root2.add((Object)"foo");
        Trie juu2 = foo2.add((Object)"juu");
        Trie daa2 = juu2.add((Object)"daa");
        root1.merge(root2);
        ToolsTestCase.assertEquals((Object)Tools.set((Object)"foo"), (Object)Tools.set((Iterable)root1));
        ToolsTestCase.assertSame((Object)foo1, (Object)root1.get((Object)"foo"));
        ToolsTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"bar", "juu"}), (Object)Tools.set((Iterable)foo1));
        ToolsTestCase.assertSame((Object)bar1, (Object)foo1.get((Object)"bar"));
        Trie juu1 = foo1.get((Object)"juu");
        ToolsTestCase.assertNotSame((Object)juu2, (Object)juu1);
        ToolsTestCase.assertEquals((Object)Tools.set((Object)"daa"), (Object)Tools.set((Iterable)juu1));
        Trie boo = juu1.add((Object)"boo");
        ToolsTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"daa", "boo"}), (Object)Tools.set((Iterable)juu1));
        ToolsTestCase.assertEquals((Object)Tools.set((Object)"daa"), (Object)Tools.set((Iterable)juu2));
    }
}

