/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends Assert {
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() {
    }

    public static long waitForOneMillis() {
        long snapshot = System.currentTimeMillis();
        try {
            while (true) {
                long now;
                if (snapshot < (now = System.currentTimeMillis())) {
                    return now;
                }
                snapshot = now;
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError("Was not expecting interruption");
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public static void fail(Throwable t) {
        throw AbstractTestCase.failure(t);
    }

    public static AssertionFailedError failure(Throwable t) {
        AssertionFailedError afe = new AssertionFailedError();
        afe.initCause(t);
        return afe;
    }

    public static AssertionFailedError failure(String msg, Throwable t) {
        AssertionFailedError afe = new AssertionFailedError(msg);
        afe.initCause(t);
        return afe;
    }

    public static AssertionFailedError failure(String msg) {
        return new AssertionFailedError(msg);
    }

    public static <T> T assertInstanceOf(Class<T> expectedInstance, Object o) {
        if (expectedInstance.isInstance(o)) {
            return expectedInstance.cast(o);
        }
        throw AbstractTestCase.failure("Was expecting " + o + " to be an instance of " + expectedInstance.getName());
    }

    public static <T> T assertNotInstanceOf(Class<?> expectedInstance, T o) {
        if (expectedInstance.isInstance(o)) {
            throw AbstractTestCase.failure("Was expecting " + o + " not to be an instance of " + expectedInstance.getName());
        }
        return o;
    }

    public static void assertDelete(File f) {
        if (!f.exists()) {
            throw AbstractTestCase.failure("Was expecting file " + f.getAbsolutePath() + " to exist");
        }
        if (!f.delete()) {
            throw AbstractTestCase.failure("Was expecting file " + f.getAbsolutePath() + " to be deleted");
        }
    }

    public static DiskFileSystem diskFS(String ... packageName) {
        File root = new File(System.getProperty("test.resources"));
        return new DiskFileSystem(root, packageName);
    }

    public final String getName() {
        return this.name.getMethodName();
    }

    public final CompilerAssert<File, File> compiler(String ... packageName) {
        return this.compiler(false, packageName);
    }

    public final CompilerAssert<File, File> incrementalCompiler(String ... packageName) {
        return this.compiler(true, packageName);
    }

    private CompilerAssert<File, File> compiler(boolean incremental, String ... packageName) {
        DiskFileSystem input = AbstractTestCase.diskFS(packageName);
        if (packageName.length == 0) {
            throw AbstractTestCase.failure("Cannot compile empty package");
        }
        String outputPath = System.getProperty("test.generated.classes");
        File a = new File(outputPath);
        if (a.exists()) {
            if (a.isFile()) {
                throw AbstractTestCase.failure("File " + outputPath + " already exist and is a file");
            }
        } else if (!a.mkdirs()) {
            throw AbstractTestCase.failure("Could not create test generated source directory " + outputPath);
        }
        String s = this.name.getMethodName();
        String pkg = Tools.join((char)'.', (String[])packageName) + "#" + s;
        File f2 = new File(a, pkg);
        int count = 0;
        while (f2.exists()) {
            f2 = new File(a, pkg + "-" + count);
            ++count;
        }
        if (!f2.mkdirs()) {
            throw AbstractTestCase.failure("Could not create test generated source directory " + f2.getAbsolutePath());
        }
        File sourceOutputDir = new File(f2, "source-output");
        AbstractTestCase.assertTrue((boolean)sourceOutputDir.mkdir());
        DiskFileSystem sourceOutput = new DiskFileSystem(sourceOutputDir);
        File classOutputDir = new File(f2, "class-output");
        AbstractTestCase.assertTrue((boolean)classOutputDir.mkdir());
        DiskFileSystem classOutput = new DiskFileSystem(classOutputDir);
        File sourcePathDir = new File(f2, "source-path");
        AbstractTestCase.assertTrue((boolean)sourcePathDir.mkdir());
        DiskFileSystem sourcePath = new DiskFileSystem(sourcePathDir);
        try {
            input.copy((ReadWriteFileSystem)sourcePath);
        }
        catch (IOException e) {
            throw AbstractTestCase.failure(e);
        }
        return new CompilerAssert<File, File>(incremental, (ReadWriteFileSystem<File>)sourcePath, (ReadWriteFileSystem<File>)sourceOutput, (ReadWriteFileSystem<File>)classOutput);
    }

    public MockApplication<?> application(InjectImplementation injectImplementation, String ... packageName) {
        CompilerAssert<File, File> helper = this.compiler(packageName);
        helper.assertCompile();
        return helper.application(injectImplementation);
    }

    public static void assertEquals(JSON expected, JSON test) {
        if (expected != null) {
            if (test == null) {
                throw AbstractTestCase.failure("Was expected " + expected + " to be not null");
            }
            if (!expected.equals((Object)test)) {
                StringBuilder sb = null;
                try {
                    sb = new StringBuilder("expected <");
                    expected.toString((Appendable)sb, 2);
                    sb.append(">  but was:<");
                    test.toString((Appendable)sb, 2);
                    sb.append(">");
                    throw AbstractTestCase.failure(sb.toString());
                }
                catch (IOException e) {
                    throw AbstractTestCase.failure("Unexpected", e);
                }
            }
        } else if (test != null) {
            throw AbstractTestCase.failure("Was expected " + test + " to be null");
        }
    }

    public static void assertNoSuchElement(Iterator<?> iterator) {
        try {
            Object next = iterator.next();
            AbstractTestCase.fail((String)("Was not expecting to obtain " + next + " element from an iterator"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static <E> void assertEquals(List<? extends E> expected, Iterable<? extends E> test) {
        int index = 0;
        Iterator<E> expectedIterator = expected.iterator();
        Iterator<E> testIterator = test.iterator();
        while (expectedIterator.hasNext()) {
            if (testIterator.hasNext()) {
                E testNext;
                E expectedNext = expectedIterator.next();
                if (!Tools.safeEquals(expectedNext, testNext = testIterator.next())) {
                    throw AbstractTestCase.failure("Elements at index " + index + " are not equals: " + expectedNext + "!=" + testNext);
                }
                ++index;
                continue;
            }
            throw AbstractTestCase.failure("Tested iterable has more elements than the expected iterable at index " + index);
        }
        if (testIterator.hasNext()) {
            throw AbstractTestCase.failure("Expected iterable has more elements than the tested iterable at index " + index);
        }
    }
}

