/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.portlet.PortletException;
import juzu.asset.AssetType;
import juzu.impl.application.ApplicationBootstrap;
import juzu.impl.application.ApplicationContext;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.asset.ManagerQualifier;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.Compiler;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.classloader.ClassLoaderFileSystem;
import juzu.impl.fs.spi.jar.JarFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.inject.spi.InjectBuilder;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.inject.spi.spring.SpringBuilder;
import juzu.impl.metadata.Descriptor;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Tools;
import juzu.processor.MainProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationRuntime<P, R, L> {
    private static final String[] CONFIG_PATH = new String[]{"juzu", "config.json"};
    protected final Logger logger;
    protected ReadFileSystem<L> libs;
    protected String name;
    protected InjectImplementation injectImplementation;
    protected ReadFileSystem<R> resources;
    protected ApplicationContext context;
    protected AssetServer assetServer;
    protected AssetManager stylesheetManager;
    protected AssetManager scriptManager;
    protected Map<String, Descriptor> plugins;

    ApplicationRuntime(Logger logger) {
        this.logger = logger;
    }

    public ReadFileSystem<L> getLibs() {
        return this.libs;
    }

    public void setLibs(ReadFileSystem<L> libs) {
        this.libs = libs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InjectImplementation getInjectImplementation() {
        return this.injectImplementation;
    }

    public void setInjectImplementation(InjectImplementation injectImplementation) {
        this.injectImplementation = injectImplementation;
    }

    public ReadFileSystem<R> getResources() {
        return this.resources;
    }

    public void setResources(ReadFileSystem<R> resources) {
        this.resources = resources;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public AssetServer getAssetServer() {
        return this.assetServer;
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public void setAssetServer(AssetServer assetServer) {
        if (assetServer != null) {
            assetServer.register(this);
        }
        if (this.assetServer != null) {
            this.assetServer.unregister(this);
        }
        this.assetServer = assetServer;
    }

    public void addPlugin(String name, Descriptor plugin) {
        if (this.plugins == null) {
            this.plugins = new HashMap<String, Descriptor>();
        }
        this.plugins.put(name, plugin);
    }

    public abstract ClassLoader getClassLoader();

    protected abstract ReadFileSystem<P> getClasses();

    public abstract Collection<CompilationError> boot() throws Exception;

    protected final void doBoot() throws Exception {
        Object springName;
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        Iterator<L> i = this.libs.getChildren(this.libs.getRoot());
        while (i.hasNext()) {
            L s = i.next();
            URL url = this.libs.getURL(s);
            jarURLs.add(url);
        }
        Object f = this.getClasses().getPath(CONFIG_PATH);
        URL url = this.getClasses().getURL(f);
        String s = Tools.read(url);
        JSON json = (JSON)JSON.parse(s);
        String fqn = null;
        if (this.name != null) {
            fqn = (String)json.get(this.name.trim());
        } else {
            for (String a : json.names()) {
                String b = json.getString(a);
                if (a.length() <= 0 || b.length() <= 0) continue;
                fqn = b;
                break;
            }
        }
        if (fqn == null) {
            throw new Exception("Could not find an application to start " + json);
        }
        Class<?> clazz = this.getClassLoader().loadClass(fqn);
        Field field = clazz.getDeclaredField("DESCRIPTOR");
        ApplicationDescriptor descriptor = (ApplicationDescriptor)field.get(null);
        if (this.plugins != null) {
            for (Map.Entry<String, Descriptor> entry : this.plugins.entrySet()) {
                descriptor.addPlugin(entry.getKey(), entry.getValue());
            }
        }
        URL mainURL = null;
        for (URL jarURL : jarURLs) {
            URL configURL = new URL("jar:" + jarURL.toString() + "!/juzu/impl/application/ApplicationBootstrap.class");
            try {
                configURL.openStream();
                mainURL = jarURL;
                break;
            }
            catch (IOException ignore) {
            }
        }
        if (mainURL == null) {
            throw new PortletException("Cannot find juzu jar among " + jarURLs);
        }
        JarFileSystem libs = new JarFileSystem(new JarFile(new File(mainURL.toURI())));
        InjectBuilder injectBootstrap = this.injectImplementation.bootstrap();
        injectBootstrap.addFileSystem(this.getClasses());
        injectBootstrap.addFileSystem(libs);
        injectBootstrap.setClassLoader(this.getClassLoader());
        if (injectBootstrap instanceof SpringBuilder && (springName = this.resources.getPath("spring.xml")) != null) {
            URL configurationURL = this.resources.getURL(springName);
            ((SpringBuilder)injectBootstrap).setConfigurationURL(configurationURL);
        }
        ApplicationBootstrap bootstrap = new ApplicationBootstrap(injectBootstrap, descriptor);
        AssetManager scriptManager = new AssetManager();
        AssetManager stylesheetManager = new AssetManager();
        injectBootstrap.bindBean(AssetManager.class, Collections.singletonList(new ManagerQualifier(AssetType.SCRIPT)), scriptManager);
        injectBootstrap.bindBean(AssetManager.class, Collections.singletonList(new ManagerQualifier(AssetType.STYLESHEET)), stylesheetManager);
        this.logger.log("Starting " + descriptor.getName());
        bootstrap.start();
        this.context = bootstrap.getContext();
        this.scriptManager = scriptManager;
        this.stylesheetManager = stylesheetManager;
    }

    public void shutdown() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dynamic<R, L, S>
    extends ApplicationRuntime<RAMPath, R, L> {
        private FileSystemScanner<S> devScanner;
        private ClassLoaderFileSystem classLoaderFS;
        private ReadFileSystem<RAMPath> classes;
        private ClassLoader classLoader;
        private ClassLoader baseClassLoader;

        public Dynamic(Logger logger) {
            super(logger);
        }

        public void init(ClassLoader baseClassLoader, ReadFileSystem<S> fss) throws Exception {
            this.devScanner = FileSystemScanner.createTimestamped(fss);
            this.devScanner.scan();
            this.logger.log("Dev mode scanner monitoring " + fss.getFile(fss.getRoot()));
            this.baseClassLoader = baseClassLoader;
            this.classLoaderFS = new ClassLoaderFileSystem(baseClassLoader);
        }

        public void init(ClassLoaderFileSystem baseClassPath, ReadFileSystem<S> fss) throws Exception {
            this.devScanner = FileSystemScanner.createTimestamped(fss);
            this.devScanner.scan();
            this.logger.log("Dev mode scanner monitoring " + fss.getFile(fss.getRoot()));
            this.baseClassLoader = baseClassPath.getClassLoader();
            this.classLoaderFS = baseClassPath;
        }

        @Override
        protected ReadFileSystem<RAMPath> getClasses() {
            return this.classes;
        }

        @Override
        public Collection<CompilationError> boot() throws Exception {
            Map<String, Change> changes = this.devScanner.scan();
            if (this.context != null) {
                if (changes.size() > 0) {
                    this.logger.log("Detected changes : " + changes);
                    this.context = null;
                } else {
                    this.logger.log("No changes detected");
                }
            }
            if (this.context == null) {
                this.logger.log("Building application");
                ReadFileSystem<S> sourcePath = this.devScanner.getFileSystem();
                RAMFileSystem classOutput = new RAMFileSystem();
                sourcePath.copy(new Filter.Default(){

                    public boolean acceptFile(Object file, String name) throws IOException {
                        return !name.endsWith(".java");
                    }
                }, classOutput);
                Compiler compiler = Compiler.builder().sourcePath(sourcePath).sourceOutput(classOutput).classOutput(classOutput).addClassPath(this.classLoaderFS).build();
                compiler.addAnnotationProcessor(new MainProcessor());
                List<CompilationError> res = compiler.compile();
                if (res.isEmpty()) {
                    this.classLoader = new URLClassLoader(new URL[]{classOutput.getURL()}, this.baseClassLoader);
                    this.classes = classOutput;
                    this.doBoot();
                    return Collections.emptyList();
                }
                return res;
            }
            return null;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Static<P, R, L>
    extends ApplicationRuntime<P, R, L> {
        private ReadFileSystem<P> classes;
        private ClassLoader classLoader;

        public Static(Logger logger) {
            super(logger);
        }

        @Override
        public ReadFileSystem<P> getClasses() {
            return this.classes;
        }

        public void setClasses(ReadFileSystem<P> classes) {
            this.classes = classes;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader cl) {
            this.classLoader = cl;
        }

        @Override
        public Collection<CompilationError> boot() throws Exception {
            if (this.context == null) {
                this.doBoot();
            }
            return null;
        }
    }
}

