/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application.metamodel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import juzu.Application;
import juzu.impl.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.application.metamodel.ApplicationsMetaModel;
import juzu.impl.application.metamodel.BufKey;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.controller.metamodel.ControllersMetaModel;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.template.metamodel.TemplatesMetaModel;
import juzu.impl.utils.FQN;
import juzu.impl.utils.JSON;

public class ApplicationMetaModel
extends MetaModelObject {
    public static final MessageCode CANNOT_WRITE_APPLICATION_CONFIG = new MessageCode("CANNOT_WRITE_APPLICATION_CONFIG", "The application %1$s configuration cannot be written");
    public static final MessageCode CANNOT_WRITE_CONFIG = new MessageCode("CANNOT_WRITE_CONFIG", "The configuration cannot be written");
    final ElementHandle.Package handle;
    final FQN fqn;
    public MetaModel model;
    boolean modified;
    final Map<BufKey, AnnotationData> toProcess;
    final Map<BufKey, AnnotationData> processed;
    final String baseName;

    ApplicationMetaModel(ElementHandle.Package handle, String baseName) {
        if (baseName == null) {
            String s = handle.getQN().getValue();
            int index = s.lastIndexOf(46);
            baseName = Character.toUpperCase(s.charAt(index + 1)) + s.substring(index + 2);
        }
        String name = baseName + "Application";
        FQN fqn = new FQN(handle.getQN(), name);
        this.handle = handle;
        this.fqn = fqn;
        this.modified = false;
        this.baseName = baseName;
        this.toProcess = new HashMap<BufKey, AnnotationData>();
        this.processed = new HashMap<BufKey, AnnotationData>();
    }

    public FQN getFQN() {
        return this.fqn;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ElementHandle.Package getHandle() {
        return this.handle;
    }

    public JSON toJSON() {
        JSON json = new JSON();
        json.set("handle", this.handle);
        json.set("fqn", this.fqn.getName());
        json.map("templates", this.getChild(TemplatesMetaModel.KEY));
        json.map("controllers", this.getChild(ControllersMetaModel.KEY));
        return json;
    }

    public boolean exist(MetaModel model) {
        boolean found;
        block1: {
            AnnotationMirror annotationMirror;
            PackageElement element = model.env.get(this.handle);
            found = false;
            if (element == null) break block1;
            Iterator<? extends AnnotationMirror> i$ = element.getAnnotationMirrors().iterator();
            while (i$.hasNext() && !(found = ((TypeElement)(annotationMirror = i$.next()).getAnnotationType().asElement()).getQualifiedName().contentEquals(Application.class.getName()))) {
            }
        }
        return found;
    }

    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ApplicationsMetaModel) {
            this.queue(MetaModelEvent.createAdded(this));
            ApplicationsMetaModel applications = (ApplicationsMetaModel)parent;
            this.model = applications.model;
            for (ApplicationMetaModelPlugin plugin : applications.plugins.values()) {
                plugin.postConstruct(this);
            }
        }
    }

    protected void preDetach(MetaModelObject parent) {
        if (parent instanceof ApplicationsMetaModel) {
            ApplicationsMetaModel applications = (ApplicationsMetaModel)parent;
            for (ApplicationMetaModelPlugin plugin : applications.plugins.values()) {
                plugin.preDestroy(this);
            }
            applications.toProcess.putAll(this.processed);
            this.toProcess.clear();
            this.queue(MetaModelEvent.createRemoved(this));
            this.model = null;
        }
    }
}

