/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application.metamodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.Application;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.application.metamodel.ApplicationMetaModel;
import juzu.impl.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.application.metamodel.BufKey;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.template.metamodel.TemplateMetaModel;
import juzu.impl.utils.FQN;
import juzu.impl.utils.JSON;
import juzu.impl.utils.QN;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationsMetaModel
extends MetaModelObject
implements Iterable<ApplicationMetaModel> {
    private static final String APPLICATION_DESCRIPTOR = ApplicationDescriptor.class.getSimpleName();
    private Map<String, String> moduleConfig;
    public static final Key<ApplicationsMetaModel> KEY = Key.of(ApplicationsMetaModel.class);
    public MetaModel model;
    final Map<BufKey, AnnotationData> toProcess = new HashMap<BufKey, AnnotationData>();
    final LinkedHashMap<String, ApplicationMetaModelPlugin> plugins = new LinkedHashMap();

    public ApplicationsMetaModel() {
        this.moduleConfig = new HashMap<String, String>();
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.map("values", this.getChildren(ApplicationMetaModel.class));
        return json;
    }

    @Override
    public Iterator<ApplicationMetaModel> iterator() {
        return this.getChildren(ApplicationMetaModel.class).iterator();
    }

    public ProcessingContext getContext() {
        return this.model.env;
    }

    public ApplicationMetaModel get(ElementHandle.Package handle) {
        return this.getChild(Key.of(handle, ApplicationMetaModel.class));
    }

    public void addPlugin(String name, ApplicationMetaModelPlugin plugin) {
        this.plugins.put(name, plugin);
        plugin.init(this);
    }

    public void postActivate(MetaModel model) {
        for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
            plugin.postActivateApplicationsMetaModel(this);
        }
        for (ApplicationMetaModel application : this) {
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.postActivate(application);
            }
        }
    }

    public void processAnnotation(MetaModel model, Element element, String annotationFQN, AnnotationData annotationData) throws CompilationException {
        PackageElement pkg = model.env.getPackageOf(element);
        QN pkgQN = QN.parse(pkg.getQualifiedName());
        ApplicationMetaModel found = null;
        if (annotationFQN.equals(Application.class.getName())) {
            found = this.processApplication((PackageElement)element, annotationData);
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.processAnnotation(found, element, annotationFQN, annotationData);
            }
        } else {
            for (ApplicationMetaModel application : this) {
                if (!application.fqn.getPackageName().isPrefix(pkgQN)) continue;
                found = application;
                break;
            }
            BufKey key = new BufKey(model.env, element, annotationFQN);
            if (found == null) {
                this.toProcess.put(key, annotationData);
                MetaModel.log.log("Buffering " + key + " = " + annotationData);
            } else {
                found.toProcess.put(key, annotationData);
            }
        }
        if (found != null) {
            Iterator<Map.Entry<BufKey, AnnotationData>> i = found.toProcess.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<BufKey, AnnotationData> entry = i.next();
                BufKey key = entry.getKey();
                AnnotationData data = entry.getValue();
                Object e = model.env.get(key.element);
                i.remove();
                MetaModel.log.log("Broadcasting annotation " + key + " = " + data);
                for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                    plugin.processAnnotation(found, (Element)e, key.annotationFQN, data);
                }
                found.processed.put(key, data);
            }
        }
    }

    public void postProcessAnnotations(MetaModel model) {
        this.resolveApplications();
        for (ApplicationMetaModel application : this) {
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.postProcessAnnotations(application);
            }
        }
    }

    public void processEvents(MetaModel model, EventQueue queue) {
        while (queue.hasEvents()) {
            MetaModelEvent event = queue.popEvent();
            this.processEvent(event);
            MetaModel.log.log("Processing meta model event " + event.getType() + " " + event.getObject());
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.processEvent(this, event);
            }
        }
    }

    private void processEvent(MetaModelEvent event) {
        MetaModelObject obj = event.getObject();
        if (obj instanceof ApplicationMetaModel) {
            ApplicationMetaModel application = (ApplicationMetaModel)obj;
            if (event.getType() == 0) {
                this.moduleConfig.put(application.getFQN().getSimpleName(), application.getFQN().getName());
                this.emitApplication(this.model.env, application);
            } else if (event.getType() == 1) {
                this.moduleConfig.remove(application.getFQN().getSimpleName());
            }
        }
    }

    public void postProcessEvents(MetaModel model) throws CompilationException {
        for (ApplicationMetaModel application : this) {
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.postProcessEvents(application);
            }
        }
    }

    public void prePassivate(MetaModel model) {
        for (ApplicationMetaModel application : this) {
            for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
                plugin.prePassivate(application);
            }
        }
        for (ApplicationMetaModelPlugin plugin : this.plugins.values()) {
            plugin.prePassivate(this);
        }
        MetaModel.log.log("Emitting config");
        this.emitConfig(model);
    }

    private ApplicationMetaModel processApplication(PackageElement packageElt, Map<String, Serializable> annotationValues) throws CompilationException {
        String name = (String)((Object)annotationValues.get("name"));
        ElementHandle.Package handle = ElementHandle.Package.create(packageElt);
        ApplicationMetaModel application = this.get(handle);
        if (application == null) {
            application = this.add(handle, name);
        } else {
            application.modified = true;
        }
        return application;
    }

    public ApplicationMetaModel add(ElementHandle.Package handle, String applicationName) {
        ApplicationMetaModel application = new ApplicationMetaModel(handle, applicationName);
        Iterator<Map.Entry<BufKey, AnnotationData>> i = this.toProcess.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<BufKey, AnnotationData> entry = i.next();
            BufKey key = entry.getKey();
            if (!handle.getQN().isPrefix(key.pkg)) continue;
            AnnotationData data = entry.getValue();
            i.remove();
            MetaModel.log.log("Moving " + key + " = " + data);
            application.toProcess.put(key, data);
        }
        this.addChild(Key.of(handle, ApplicationMetaModel.class), application);
        return application;
    }

    private void resolveApplications() {
        for (ApplicationMetaModel application : this.getChildren(ApplicationMetaModel.class)) {
            if (!application.modified) continue;
            this.queue(MetaModelEvent.createUpdated(application));
            application.modified = false;
        }
    }

    private void emitApplication(ProcessingContext env, ApplicationMetaModel application) throws CompilationException {
        PackageElement elt = env.get(application.getHandle());
        FQN fqn = application.getFQN();
        Writer writer = null;
        try {
            JavaFileObject applicationFile = env.createSourceFile(fqn, elt);
            writer = applicationFile.openWriter();
            writer.append("package ").append(fqn.getPackageName()).append(";\n");
            writer.append("import ").append(Tools.getImport(ApplicationDescriptor.class)).append(";\n");
            writer.append("public class ").append(fqn.getSimpleName()).append(" {\n");
            writer.append("public static final ").append(APPLICATION_DESCRIPTOR).append(" DESCRIPTOR = new ").append(APPLICATION_DESCRIPTOR).append("(");
            writer.append(fqn.getSimpleName()).append(".class");
            writer.append(");\n");
            writer.append("}\n");
            MetaModel.log.log("Generated application " + fqn.getName() + " as " + applicationFile.toUri());
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_APPLICATION.failure(e, elt, application.getFQN());
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }

    private void emitConfig(MetaModel model) {
        JSON descriptor = new JSON();
        descriptor.merge(this.moduleConfig);
        Writer writer = null;
        try {
            FileObject fo = model.env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, "juzu", "config.json", new Element[0]);
            writer = fo.openWriter();
            descriptor.toString(writer, 2);
        }
        catch (IOException e) {
            try {
                throw ApplicationMetaModel.CANNOT_WRITE_CONFIG.failure(e);
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
        for (ApplicationMetaModel application : model.getChild(KEY)) {
            descriptor.clear();
            for (Map.Entry<String, ApplicationMetaModelPlugin> entry : this.plugins.entrySet()) {
                JSON pluginDescriptor = entry.getValue().getDescriptor(application);
                if (pluginDescriptor == null) continue;
                descriptor.set(entry.getKey(), pluginDescriptor);
            }
            writer = null;
            try {
                FileObject fo = model.env.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, application.getFQN().getPackageName(), "config.json", new Element[0]);
                writer = fo.openWriter();
                descriptor.toString(writer, 2);
            }
            catch (IOException e) {
                throw ApplicationMetaModel.CANNOT_WRITE_APPLICATION_CONFIG.failure(e, model.env.get(application.getHandle()), application.getFQN());
            }
            finally {
                Tools.safeClose(writer);
            }
        }
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        this.model = (MetaModel)parent;
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        this.model = null;
    }
}

