/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.application.metamodel;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import juzu.Application;
import juzu.impl.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.application.metamodel.ApplicationsMetaModel;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.utils.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationsMetaModelPlugin
extends MetaModelPlugin {
    private HashSet<Class<? extends Annotation>> annotationTypes;

    public ApplicationsMetaModelPlugin() {
        super("applications");
    }

    @Override
    public Set<Class<? extends Annotation>> getAnnotationTypes() {
        return this.annotationTypes;
    }

    @Override
    public JSON toJSON(MetaModel metaModel) {
        return metaModel.getChild(ApplicationsMetaModel.KEY).toJSON();
    }

    @Override
    public void init(MetaModel metaModel) {
        LinkedHashMap<String, ApplicationMetaModelPlugin> plugins = new LinkedHashMap<String, ApplicationMetaModelPlugin>();
        StringBuilder msg = new StringBuilder("Using application plugins:");
        for (ApplicationMetaModelPlugin plugin : metaModel.env.loadServices(ApplicationMetaModelPlugin.class)) {
            msg.append(" ").append(plugin.getName());
            plugins.put(plugin.getName(), plugin);
        }
        MetaModel.log.log(msg);
        HashSet<Class> annotationTypes = new HashSet<Class>();
        annotationTypes.add(Application.class);
        for (ApplicationMetaModelPlugin plugin : plugins.values()) {
            Set<Class<? extends Annotation>> processed = plugin.getAnnotationTypes();
            MetaModel.log.log("Application plugin " + plugin.getName() + " wants to process " + processed);
            annotationTypes.addAll(processed);
        }
        ApplicationsMetaModel application = new ApplicationsMetaModel();
        metaModel.addChild(ApplicationsMetaModel.KEY, application);
        for (Map.Entry entry : plugins.entrySet()) {
            application.addPlugin((String)entry.getKey(), (ApplicationMetaModelPlugin)entry.getValue());
        }
        this.annotationTypes = annotationTypes;
    }

    @Override
    public void postActivate(MetaModel metaModel) {
        metaModel.getChild(ApplicationsMetaModel.KEY).postActivate(metaModel);
    }

    @Override
    public void processAnnotation(MetaModel metaModel, Element element, String fqn, AnnotationData data) {
        metaModel.getChild(ApplicationsMetaModel.KEY).processAnnotation(metaModel, element, fqn, data);
    }

    @Override
    public void postProcessAnnotations(MetaModel metaModel) {
        metaModel.getChild(ApplicationsMetaModel.KEY).postProcessAnnotations(metaModel);
    }

    @Override
    public void processEvents(MetaModel metaModel, EventQueue queue) {
        metaModel.getChild(ApplicationsMetaModel.KEY).processEvents(metaModel, queue);
    }

    @Override
    public void postProcessEvents(MetaModel metaModel) {
        metaModel.getChild(ApplicationsMetaModel.KEY).postProcessEvents(metaModel);
    }

    @Override
    public void prePassivate(MetaModel metaModel) {
        metaModel.getChild(ApplicationsMetaModel.KEY).prePassivate(metaModel);
    }
}

