/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import juzu.impl.compiler.CompilationMessage;
import juzu.impl.compiler.MessageCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationException
extends RuntimeException
implements Iterable<CompilationMessage> {
    private final List<CompilationMessage> messages;
    private final Element element;
    private final AnnotationMirror annotation;

    public CompilationException(MessageCode code, Object ... arguments) {
        this(null, code, arguments);
    }

    public CompilationException(Element element, MessageCode code, Object ... arguments) {
        this(element, null, code, arguments);
    }

    public CompilationException(Element element, AnnotationMirror annotation, MessageCode code, Object ... arguments) {
        this(element, annotation, new CompilationMessage(code, arguments));
    }

    public CompilationException(Element element, AnnotationMirror annotation, CompilationMessage ... messages) {
        this(element, annotation, Arrays.asList(messages));
    }

    public CompilationException(Element element, AnnotationMirror annotation, List<CompilationMessage> messages) {
        this.element = element;
        this.annotation = annotation;
        this.messages = messages;
    }

    @Override
    public Iterator<CompilationMessage> iterator() {
        return this.messages.iterator();
    }

    @Override
    public synchronized CompilationException initCause(Throwable cause) {
        return (CompilationException)super.initCause(cause);
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public List<CompilationMessage> getMessages() {
        return this.messages;
    }
}

