/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.controller.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.controller.metamodel.ControllerMethodMetaModel;
import juzu.impl.controller.metamodel.ControllersMetaModel;
import juzu.impl.controller.metamodel.ParameterMetaModel;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.utils.Cardinality;
import juzu.impl.utils.JSON;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerMetaModel
extends MetaModelObject {
    public static final MessageCode CANNOT_WRITE_CONTROLLER_COMPANION = new MessageCode("CANNOT_WRITE_CONTROLLER_COMPANION", "The controller companion %1$s cannot be written");
    public static final MessageCode CONTROLLER_METHOD_NOT_RESOLVED = new MessageCode("CONTROLLER_METHOD_NOT_RESOLVED", "The controller method cannot be resolved %1$s");
    public static final MessageCode CONTROLLER_METHOD_DUPLICATE_ID = new MessageCode("CONTROLLER_METHOD_DUPLICATE_ID", "Duplicate method controller id %1$s");
    public static final MessageCode CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED = new MessageCode("CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED", "The method parameter type %1s should be a string or annotated with @juzu.Param");
    boolean modified;
    ControllersMetaModel controllers;
    final ElementHandle.Class handle;

    public ControllerMetaModel(ElementHandle.Class handle) {
        this.handle = handle;
        this.modified = false;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("handle", this.handle);
        json.map("methods", this.getMethods());
        return json;
    }

    public ElementHandle.Class getHandle() {
        return this.handle;
    }

    public Collection<ControllerMethodMetaModel> getMethods() {
        return this.getChildren(ControllerMethodMetaModel.class);
    }

    public void remove(ElementHandle.Method handle) {
        this.removeChild(Key.of(handle, ControllerMethodMetaModel.class));
    }

    public ControllerMethodMetaModel addMethod(Phase phase, String name, Iterable<Map.Entry<String, String>> parameters) {
        throw new UnsupportedOperationException("remove me at some point");
    }

    void addMethod(MetaModel context, ExecutableElement methodElt, String annotationFQN, Map<String, Serializable> annotationValues) {
        String id = (String)((Object)annotationValues.get("id"));
        for (Phase phase : Phase.values()) {
            if (!phase.annotation.getName().equals(annotationFQN)) continue;
            ElementHandle.Method origin = ElementHandle.Method.create(methodElt);
            Key<ControllerMethodMetaModel> key = Key.of(origin, ControllerMethodMetaModel.class);
            if (this.getChild(key) != null) break;
            for (ControllerMethodMetaModel existing : this.getChildren(ControllerMethodMetaModel.class)) {
                if (existing.id == null || !existing.id.equals(id)) continue;
                throw CONTROLLER_METHOD_DUPLICATE_ID.failure((Element)methodElt, id);
            }
            ArrayList<ParameterMetaModel> parameters = new ArrayList<ParameterMetaModel>();
            List<? extends TypeMirror> parameterTypeMirrors = ((ExecutableType)methodElt.asType()).getParameterTypes();
            List<? extends VariableElement> parameterVariableElements = methodElt.getParameters();
            for (int i = 0; i < parameterTypeMirrors.size(); ++i) {
                TypeMirror parameterSimpleTypeMirror;
                Cardinality parameterCardinality;
                VariableElement parameterVariableElt = parameterVariableElements.get(i);
                TypeMirror parameterTypeMirror = parameterTypeMirrors.get(i);
                TypeMirror erasedParameterTypeMirror = context.env.erasure(parameterTypeMirror);
                String parameterType = ((Object)erasedParameterTypeMirror).toString();
                String parameterName = parameterVariableElt.getSimpleName().toString();
                switch (parameterTypeMirror.getKind()) {
                    case DECLARED: {
                        DeclaredType dt = (DeclaredType)parameterTypeMirror;
                        TypeElement col = context.env.getTypeElement("java.util.List");
                        TypeMirror tm = context.env.erasure(col.asType());
                        TypeMirror err = context.env.erasure(dt);
                        if (((Object)err).equals(tm)) {
                            if (dt.getTypeArguments().size() != 1) {
                                throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                            }
                            parameterCardinality = Cardinality.LIST;
                            parameterSimpleTypeMirror = dt.getTypeArguments().get(0);
                            break;
                        }
                        parameterCardinality = Cardinality.SINGLE;
                        parameterSimpleTypeMirror = parameterTypeMirror;
                        break;
                    }
                    case ARRAY: {
                        ArrayType arrayType = (ArrayType)parameterTypeMirror;
                        parameterCardinality = Cardinality.ARRAY;
                        parameterSimpleTypeMirror = arrayType.getComponentType();
                        break;
                    }
                    default: {
                        throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                    }
                }
                if (parameterSimpleTypeMirror.getKind() != TypeKind.DECLARED) {
                    throw CONTROLLER_METHOD_PARAMETER_NOT_RESOLVED.failure(parameterVariableElt);
                }
                TypeElement te = (TypeElement)context.env.asElement(parameterSimpleTypeMirror);
                ElementHandle.Class a = ElementHandle.Class.create(te);
                parameters.add(new ParameterMetaModel(parameterName, parameterCardinality, a, parameterType));
            }
            ControllerMethodMetaModel method = new ControllerMethodMetaModel(origin, id, phase, methodElt.getSimpleName().toString(), parameters);
            this.addChild(key, method);
            this.modified = true;
            break;
        }
    }

    @Override
    public boolean exist(MetaModel model) {
        return this.getChildren().size() > 0;
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        if (parent instanceof ControllersMetaModel) {
            this.queue(MetaModelEvent.createRemoved(this));
            this.controllers = null;
        }
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof ControllersMetaModel) {
            this.controllers = (ControllersMetaModel)parent;
            this.queue(MetaModelEvent.createAdded(this));
        }
    }
}

