/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import juzu.impl.fs.Change;
import juzu.impl.fs.Filter;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.utils.Content;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystemScanner<P>
implements Visitor<P>,
Filter<P> {
    protected final ReadFileSystem<P> fs;
    private StringBuilder sb = new StringBuilder();
    private Map<String, Data> snapshot = new HashMap<String, Data>();

    public static <P> FileSystemScanner<P> createTimestamped(ReadFileSystem<P> fs) {
        return new Timestamped<P>(fs);
    }

    public static <P> FileSystemScanner<P> createHashing(ReadFileSystem<P> fs) {
        return new Hash<P>(fs);
    }

    private FileSystemScanner(ReadFileSystem<P> fs) {
        this.fs = fs;
    }

    public ReadFileSystem<P> getFileSystem() {
        return this.fs;
    }

    public Map<String, Change> scan() throws IOException {
        for (Data data : this.snapshot.values()) {
            data.change = Change.REMOVE;
        }
        this.fs.traverse(this, (Visitor<FileSystemScanner>)this);
        LinkedHashMap<String, Change> changes = new LinkedHashMap<String, Change>();
        Iterator<Map.Entry<String, Data>> i = this.snapshot.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Data> entry = i.next();
            Data data = entry.getValue();
            if (data.change == null) continue;
            changes.put(entry.getKey(), data.change);
            if (data.change != Change.REMOVE) continue;
            i.remove();
        }
        return changes;
    }

    @Override
    public boolean acceptDir(P dir, String name) throws IOException {
        return !name.startsWith(".");
    }

    @Override
    public boolean acceptFile(P file, String name) throws IOException {
        return !name.startsWith(".");
    }

    @Override
    public void enterDir(P dir, String name) throws IOException {
    }

    @Override
    public void file(P file, String name) throws IOException {
        long lastModified = this.createValue(file);
        this.fs.pathOf(file, '/', this.sb);
        String id = this.sb.toString();
        this.sb.setLength(0);
        Data data = this.snapshot.get(id);
        if (data == null) {
            this.snapshot.put(id, new Data(lastModified));
        } else if (this.isModified(data.lastModified, lastModified)) {
            data.lastModified = lastModified;
            data.change = Change.UPDATE;
        } else {
            data.change = null;
        }
    }

    @Override
    public void leaveDir(P dir, String name) throws IOException {
    }

    protected abstract long createValue(P var1) throws IOException;

    protected abstract boolean isModified(long var1, long var3);

    private static class Data {
        private long lastModified;
        private Change change;

        private Data(long lastModified) {
            this.lastModified = lastModified;
            this.change = Change.ADD;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Hash<P>
    extends FileSystemScanner<P> {
        public Hash(ReadFileSystem<P> fs) {
            super(fs);
        }

        @Override
        protected long createValue(P file) throws IOException {
            try {
                Content content = this.fs.getContent(file);
                MessageDigest digest = MessageDigest.getInstance("MD5");
                InputStream in = content.getInputStream();
                byte[] bytes = Tools.bytes(in);
                byte[] md5 = digest.digest(bytes);
                long value = 0L;
                for (byte b : md5) {
                    value = value * 256L + (long)Tools.unsignedByteToInt(b);
                }
                return value;
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected boolean isModified(long snapshot, long current) {
            return snapshot != current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Timestamped<P>
    extends FileSystemScanner<P> {
        public Timestamped(ReadFileSystem<P> fs) {
            super(fs);
        }

        @Override
        protected long createValue(P file) throws IOException {
            return this.fs.getLastModified(file);
        }

        @Override
        protected boolean isModified(long snapshot, long current) {
            return snapshot < current;
        }
    }
}

