/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import juzu.impl.utils.Tools;
import juzu.impl.utils.Trie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class URLCache {
    private final Trie<String, URL> root = new Trie();

    void add(ClassLoader classLoader) throws IOException {
        Enumeration<URL> i = classLoader.getResources("");
        while (i.hasMoreElements()) {
            URL url = i.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            try {
                File f = new File(url.toURI());
                if (!f.isDirectory()) continue;
                URLCache.add(this.root, f);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        ArrayList<URL> items = Collections.list(classLoader.getResources("META-INF/MANIFEST.MF"));
        for (URL item : items) {
            if (!"jar".equals(item.getProtocol())) continue;
            String path = item.getPath();
            int pos = path.indexOf("!/");
            URL url = new URL(path.substring(0, pos));
            URLCache.add(this.root, url);
        }
    }

    void add(Class<?> clazz) throws IOException {
        URL inject = clazz.getClassLoader().getResource("javax/inject/Inject.class");
        if (inject != null && "jar".equals(inject.getProtocol())) {
            String path = inject.getPath();
            int pos = path.indexOf("!/");
            URL url = new URL(path.substring(0, pos));
            URLCache.add(this.root, url);
        }
    }

    Trie<String, URL> get(Iterable<String> names) throws IOException {
        return this.root.get(names.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(Trie<String, URL> root, URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                ZipFile jarFile = new ZipFile(f);
                Enumeration<? extends ZipEntry> en = jarFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    URLCache.add(root, url, entry);
                }
            }
            catch (URISyntaxException e1) {
                throw new IOException("Could not access jar file " + url, e1);
            }
        }
        ZipInputStream in = new ZipInputStream(url.openStream());
        try {
            ZipEntry jarEntry = in.getNextEntry();
            while (jarEntry != null) {
                URLCache.add(root, url, jarEntry);
                jarEntry = in.getNextEntry();
            }
        }
        finally {
            Tools.safeClose(in);
        }
    }

    private static void add(Trie<String, URL> trie, File f) throws IOException {
        for (File file : f.listFiles()) {
            Trie<String, URL> child = trie.add(file.getName());
            if (file.isDirectory()) {
                URLCache.add(child, file);
                continue;
            }
            child.value(file.toURI().toURL());
        }
    }

    private static void add(Trie<String, URL> root, URL baseURL, ZipEntry entry) throws IOException {
        String name = entry.getName();
        if (!entry.isDirectory()) {
            String[] names = Tools.split(name, '/');
            Trie<String, URL> trie = root.add((String[])names);
            URL entryURL = new URL("jar:" + baseURL + "!/" + name);
            trie.value(entryURL);
        }
    }
}

