/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.ram;

import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAMPath {
    private final String name;
    private RAMDir parent;

    public RAMPath() {
        this.name = "";
        this.parent = null;
    }

    RAMPath(RAMDir parent, String name) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parent = parent;
    }

    public abstract RAMDir addDir(String var1);

    public abstract RAMFile addFile(String var1);

    public abstract Content getContent();

    public final RAMFile update(String content) {
        return this.update(new Content(System.currentTimeMillis(), content));
    }

    public abstract RAMFile update(Content var1);

    public abstract RAMPath getChild(String var1);

    public abstract Iterable<RAMPath> getChildren();

    public abstract long getLastModified();

    public abstract void touch();

    public final String getName() {
        return this.name;
    }

    public final RAMDir getParent() {
        return this.parent;
    }

    public final void del() {
        if (this.name.length() == 0) {
            throw new UnsupportedOperationException("Cannot remove root file");
        }
        if (this.parent == null) {
            throw new IllegalStateException("Cannot remove removed file");
        }
        this.parent.children.remove(this.name);
        this.parent = null;
    }
}

