/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.BeanFilter;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectBuilder;
import juzu.impl.inject.spi.InjectManager;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIManager;
import juzu.impl.inject.spi.cdi.DeclaredBean;
import juzu.impl.inject.spi.cdi.DeclaredProviderBean;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.inject.spi.cdi.SingletonProviderBean;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIBuilder
extends InjectBuilder {
    private Set<Scope> scopes = new HashSet<Scope>();
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems = new ArrayList();
    private ArrayList<AbstractBean> boundBeans = new ArrayList();
    private BeanFilter filter = null;

    @Override
    public <T> InjectBuilder declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        this.boundBeans.add(new DeclaredBean(implementationType != null ? implementationType : type, beanScope, qualifiers));
        return this;
    }

    @Override
    public <T> InjectBuilder declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        this.boundBeans.add(new DeclaredProviderBean(type, beanScope, qualifiers, provider));
        return this;
    }

    @Override
    public <P> InjectBuilder addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public InjectBuilder addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public InjectBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public InjectBuilder setFilter(BeanFilter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public <T> InjectBuilder bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        this.boundBeans.add(new SingletonBean(type, qualifiers, instance));
        return this;
    }

    @Override
    public <T> InjectBuilder bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<T> provider) {
        this.boundBeans.add(new SingletonProviderBean(beanType, beanScope, beanQualifiers, provider));
        return this;
    }

    public InjectManager<?, ?> create() throws Exception {
        WeldContainer container = new WeldContainer(this.classLoader, ScopeController.INSTANCE, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        return new CDIManager(container, this.filter, this.boundBeans);
    }
}

